/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism;

import com.github.klikli_dev.occultism.api.OccultismAPI;
import com.github.klikli_dev.occultism.client.gui.DimensionalMineshaftScreen;
import com.github.klikli_dev.occultism.client.gui.spirit.SpiritGui;
import com.github.klikli_dev.occultism.client.gui.storage.StableWormholeGui;
import com.github.klikli_dev.occultism.client.gui.storage.StorageControllerGui;
import com.github.klikli_dev.occultism.client.gui.storage.StorageRemoteGui;
import com.github.klikli_dev.occultism.client.render.SelectedBlockRenderer;
import com.github.klikli_dev.occultism.client.render.ThirdEyeEffectRenderer;
import com.github.klikli_dev.occultism.client.render.entity.AfritRenderer;
import com.github.klikli_dev.occultism.client.render.entity.DjinniRenderer;
import com.github.klikli_dev.occultism.client.render.entity.FoliotRenderer;
import com.github.klikli_dev.occultism.client.render.entity.OtherworldBirdRenderer;
import com.github.klikli_dev.occultism.client.render.tile.SacrificialBowlRenderer;
import com.github.klikli_dev.occultism.client.render.tile.StorageControllerRenderer;
import com.github.klikli_dev.occultism.common.DebugHelper;
import com.github.klikli_dev.occultism.common.OccultismItemGroup;
import com.github.klikli_dev.occultism.common.world.WorldGenHandler;
import com.github.klikli_dev.occultism.config.OccultismConfig;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismBiomeFeatures;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismCapabilities;
import com.github.klikli_dev.occultism.registry.OccultismContainers;
import com.github.klikli_dev.occultism.registry.OccultismEffects;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.registry.OccultismParticles;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.github.klikli_dev.occultism.registry.OccultismRituals;
import com.github.klikli_dev.occultism.registry.OccultismSounds;
import com.github.klikli_dev.occultism.registry.OccultismTiles;
import com.github.klikli_dev.occultism.util.StaticUtil;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.EndermanRenderer;
import net.minecraft.client.renderer.entity.EndermiteRenderer;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.client.renderer.entity.WitherSkeletonRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vazkii.patchouli.api.PatchouliAPI;

@Mod(value="occultism")
public class Occultism {
    public static final String MODID = "occultism";
    public static final String NAME = "Occultism";
    public static final ItemGroup ITEM_GROUP = new OccultismItemGroup();
    public static final Logger LOGGER = LogManager.getLogger((String)"occultism");
    public static final OccultismConfig CONFIG = new OccultismConfig();
    public static final SelectedBlockRenderer SELECTED_BLOCK_RENDERER = new SelectedBlockRenderer();
    public static final ThirdEyeEffectRenderer THIRD_EYE_EFFECT_RENDERER = new ThirdEyeEffectRenderer();
    public static final DebugHelper DEBUG = new DebugHelper();
    public static Occultism INSTANCE;

    public Occultism() {
        INSTANCE = this;
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Occultism.CONFIG.spec);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        OccultismEffects.EFFECTS.register(modEventBus);
        OccultismRecipes.RECIPES.register(modEventBus);
        OccultismBlocks.BLOCKS.register(modEventBus);
        OccultismItems.ITEMS.register(modEventBus);
        OccultismTiles.TILES.register(modEventBus);
        OccultismContainers.CONTAINERS.register(modEventBus);
        OccultismEntities.ENTITIES.register(modEventBus);
        OccultismSounds.SOUNDS.register(modEventBus);
        OccultismParticles.PARTICLES.register(modEventBus);
        OccultismBiomeFeatures.FEATURES.register(modEventBus);
        modEventBus.addListener(OccultismCapabilities::commonSetup);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::serverSetup);
        modEventBus.addListener(this::onModConfigEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onModConfigEvent(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getSpec() == Occultism.CONFIG.spec) {
            CONFIG.clear();
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        OccultismPackets.registerMessages();
        WorldGenHandler.setupOreGeneration();
        WorldGenHandler.setupUndergroundGroveGeneration();
        OccultismAPI.commonSetup();
        OccultismRituals.PENTACLE_REGISTRY.getValues().forEach(pentacle -> {
            ResourceLocation multiBlockId = StaticUtil.modLoc("pentacle." + pentacle.getRegistryName().func_110623_a());
            if (PatchouliAPI.instance.getMultiblock(multiBlockId) == null) {
                pentacle.registerMultiblock(multiBlockId);
            }
        });
        LOGGER.info("Common setup complete.");
    }

    private void serverSetup(FMLDedicatedServerSetupEvent event) {
        LOGGER.info("Dedicated server setup complete.");
    }

    private void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)SELECTED_BLOCK_RENDERER);
        MinecraftForge.EVENT_BUS.register((Object)THIRD_EYE_EFFECT_RENDERER);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.FOLIOT.get()), FoliotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.DJINNI.get()), DjinniRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.AFRIT.get()), AfritRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.AFRIT_WILD.get()), AfritRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.POSSESSED_ENDERMITE.get()), EndermiteRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.POSSESSED_SKELETON.get()), SkeletonRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.POSSESSED_ENDERMAN.get()), EndermanRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.WILD_HUNT_SKELETON.get()), SkeletonRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.WILD_HUNT_WITHER_SKELETON.get()), WitherSkeletonRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)OccultismEntities.OTHERWORLD_BIRD.get()), OtherworldBirdRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)OccultismTiles.STORAGE_CONTROLLER.get()), StorageControllerRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)OccultismTiles.SACRIFICIAL_BOWL.get()), SacrificialBowlRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)OccultismTiles.GOLDEN_SACRIFICIAL_BOWL.get()), SacrificialBowlRenderer::new);
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.CHALK_GLYPH_WHITE.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.CHALK_GLYPH_GOLD.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.CHALK_GLYPH_PURPLE.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.CHALK_GLYPH_RED.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.STABLE_WORMHOLE.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.DATURA.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.SPIRIT_FIRE.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.OTHERWORLD_SAPLING.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.OTHERWORLD_SAPLING_NATURAL.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.OTHERWORLD_LEAVES.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)OccultismBlocks.OTHERWORLD_LEAVES_NATURAL.get()), (RenderType)RenderType.func_228641_d_());
        DeferredWorkQueue.runLater(() -> {
            ScreenManager.func_216911_a((ContainerType)((ContainerType)OccultismContainers.STORAGE_CONTROLLER.get()), StorageControllerGui::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)OccultismContainers.STABLE_WORMHOLE.get()), StableWormholeGui::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)OccultismContainers.STORAGE_REMOTE.get()), StorageRemoteGui::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)OccultismContainers.SPIRIT.get()), SpiritGui::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)OccultismContainers.OTHERWORLD_MINER.get()), DimensionalMineshaftScreen::new);
            LOGGER.debug("Registered Screen Containers");
        });
        LOGGER.info("Client setup complete.");
    }
}

