/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.divination;

import com.github.klikli_dev.occultism.client.divination.Scanner;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class ScanManager {
    public static final ScanManager instance = new ScanManager();
    public static final int SCAN_DURATION_TICKS = 40;
    public static final int SCAN_RADIUS_BLOCKS = 96;
    List<BlockPos> results = new ArrayList<BlockPos>();
    private Scanner scanner;
    private int scanningTicks = -1;

    public void beginScan(PlayerEntity player, Block target) {
        this.cancelScan();
        this.scanner = new Scanner(target);
        this.scanner.initialize(player, player.func_174791_d(), 96.0f, 40);
    }

    public void updateScan(PlayerEntity player, boolean forceFinish) {
        int remainingTicks = 40 - this.scanningTicks;
        if (remainingTicks <= 0 || this.scanner == null) {
            return;
        }
        if (!forceFinish) {
            this.scanner.scan(result -> this.results.add((BlockPos)result));
            ++this.scanningTicks;
            return;
        }
        for (int i = 0; i < remainingTicks; ++i) {
            this.scanner.scan(result -> this.results.add((BlockPos)result));
            ++this.scanningTicks;
        }
    }

    public BlockPos finishScan(PlayerEntity player) {
        this.updateScan(player, true);
        Vec3d scanCenter = player.func_174791_d();
        this.results.sort(Comparator.comparing(result -> scanCenter.func_72436_e(Math3DUtil.center(result))));
        BlockPos result2 = !this.results.isEmpty() ? this.results.get(0) : null;
        this.cancelScan();
        return result2;
    }

    public void cancelScan() {
        this.scanner = null;
        this.results.clear();
        this.scanningTicks = -1;
    }
}

