/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.divination;

import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class Scanner {
    protected Block target;
    protected PlayerEntity player;
    protected Vec3d center;
    protected float radius;
    protected float radiusSquared;
    protected BlockPos min;
    protected BlockPos max;
    protected int x;
    protected int y;
    protected int z;
    private int blocksPerTick;

    public Scanner(Block target) {
        this.target = target;
    }

    public void initialize(PlayerEntity player, Vec3d center, float radius, int totalTicks) {
        this.player = player;
        this.center = center;
        this.radius = radius;
        this.radiusSquared = this.radius * this.radius;
        this.min = new BlockPos(center).func_177963_a((double)(-this.radius), (double)(-this.radius), (double)(-this.radius));
        this.max = new BlockPos(center).func_177963_a((double)this.radius, (double)this.radius, (double)this.radius);
        this.x = this.min.func_177958_n();
        this.y = this.min.func_177956_o() - 1;
        this.z = this.min.func_177952_p();
        BlockPos size = this.max.func_177973_b((Vec3i)this.min);
        int blockCount = (size.func_177958_n() + 1) * (size.func_177956_o() + 1) * (size.func_177952_p() + 1);
        this.blocksPerTick = MathHelper.func_76123_f((float)((float)blockCount / (float)totalTicks));
    }

    public void reset() {
        this.player = null;
        this.center = null;
        this.radius = 0.0f;
        this.radiusSquared = 0.0f;
        this.min = null;
        this.max = null;
    }

    public void scan(Consumer<BlockPos> resultConsumer) {
        World world = this.player.field_70170_p;
        for (int i = 0; i < this.blocksPerTick; ++i) {
            BlockPos pos;
            BlockState state;
            if (!this.nextBlock(world)) {
                return;
            }
            if (this.center.func_186679_c((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) > (double)this.radiusSquared || !this.isValidBlock(state = world.func_180495_p(pos = new BlockPos(this.x, this.y, this.z)))) continue;
            resultConsumer.accept(pos);
        }
    }

    public boolean nextBlock(World world) {
        ++this.y;
        if (this.y > this.max.func_177956_o() || this.y >= world.func_217301_I()) {
            this.y = this.min.func_177956_o();
            ++this.x;
            if (this.x > this.max.func_177958_n()) {
                this.x = this.min.func_177958_n();
                ++this.z;
                if (this.z > this.max.func_177952_p()) {
                    this.blocksPerTick = 0;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isValidBlock(BlockState state) {
        return state.func_177230_c() == this.target;
    }
}

