/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.gui.controls;

import com.github.klikli_dev.occultism.api.client.gui.IStorageControllerGuiContainer;
import com.github.klikli_dev.occultism.util.TextUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;

public class ItemSlotWidget {
    protected int x;
    protected int y;
    protected int stackSize;
    protected int guiLeft;
    protected int guiTop;
    protected boolean showStackSize;
    protected Minecraft minecraft;
    protected IStorageControllerGuiContainer parent;
    protected ItemStack stack;
    protected FontRenderer fontRenderer;
    protected int slotHighlightColor;

    public ItemSlotWidget(IStorageControllerGuiContainer parent, @Nonnull ItemStack stack, int x, int y, int stackSize, int guiLeft, int guiTop, boolean showStackSize) {
        this.x = x;
        this.y = y;
        this.stackSize = stackSize;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.showStackSize = showStackSize;
        this.parent = parent;
        this.minecraft = Minecraft.func_71410_x();
        this.stack = stack;
        this.fontRenderer = this.parent.getFontRenderer();
        this.slotHighlightColor = new Color(255, 255, 255, 128).getRGB();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public boolean getShowStackSize() {
        return this.showStackSize;
    }

    public void setShowStackSize(boolean showStackSize) {
        this.showStackSize = showStackSize;
    }

    public boolean isMouseOverSlot(int mouseX, int mouseY) {
        return this.parent.isPointInRegionController(this.x - this.guiLeft, this.y - this.guiTop, 16, 16, mouseX, mouseY);
    }

    public void drawSlot(int mx, int my) {
        RenderSystem.pushMatrix();
        if (!this.getStack().func_190926_b()) {
            if (this.showStackSize) {
                String amount = Screen.hasShiftDown() ? Integer.toString(this.stackSize) : TextUtil.formatLargeNumber(this.stackSize);
                RenderSystem.pushMatrix();
                RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                this.minecraft.func_175599_af().field_77023_b = -0.1f;
                this.minecraft.func_175599_af().func_180453_a(this.fontRenderer, this.stack, this.x * 2 + 16, this.y * 2 + 16, amount);
                RenderSystem.popMatrix();
            }
            this.minecraft.func_175599_af().field_77023_b = -100.0f;
            this.minecraft.func_175599_af().func_180450_b(this.getStack(), this.x, this.y);
            if (this.isMouseOverSlot(mx, my)) {
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.parent.drawGradientRect(this.x, this.y, this.x + 16, this.y + 16, this.slotHighlightColor, this.slotHighlightColor);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
        }
        RenderSystem.popMatrix();
    }

    public void drawTooltip(int mx, int my) {
        if (this.isMouseOverSlot(mx, my) && !this.getStack().func_190926_b()) {
            this.parent.renderToolTip(this.getStack(), mx, my);
        }
    }
}

