/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.gui.controls;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;

public class LabelWidget
extends Widget {
    public List<String> lines = new ArrayList<String>();
    public boolean centered = false;
    public boolean rightAligned = false;
    public int width = 0;
    public int margin = 2;
    public boolean shadow = false;

    public LabelWidget(int xIn, int yIn) {
        this(xIn, yIn, false);
    }

    public LabelWidget(int xIn, int yIn, boolean centered) {
        this(xIn, yIn, centered, -1);
    }

    public LabelWidget(int xIn, int yIn, boolean centered, int width) {
        this(xIn, yIn, centered, width, 2);
    }

    public LabelWidget(int xIn, int yIn, boolean centered, int width, int margin) {
        this(xIn, yIn, centered, width, margin, 0xFFFFFF);
    }

    public LabelWidget(int xIn, int yIn, boolean centered, int width, int margin, int color) {
        super(xIn, yIn, "");
        this.centered = centered;
        this.width = width;
        this.margin = margin;
        this.packedFGColor = color;
        this.active = false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontrenderer = minecraft.field_71466_p;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (this.centered && this.width <= 0 && this.lines.size() > 0) {
                this.width = fontrenderer.func_78256_a(this.lines.get(0));
            }
            int color = this.getFGColor();
            for (int i = 0; i < this.lines.size(); ++i) {
                fontrenderer.getClass();
                int top = this.y + i * (9 + this.margin);
                if (this.centered) {
                    this.drawCenteredString(fontrenderer, this.lines.get(i), this.x, top, color);
                    continue;
                }
                if (this.rightAligned) {
                    this.drawRightAlignedString(fontrenderer, this.lines.get(i), this.x, top, color);
                    continue;
                }
                this.drawString(fontrenderer, this.lines.get(i), this.x, top, color);
            }
        }
    }

    public void drawCenteredString(FontRenderer fontRenderer, String text, int x, int y, int color) {
        if (this.shadow) {
            fontRenderer.func_175063_a(text, (float)(x - fontRenderer.func_78256_a(text) / 2), (float)y, color);
        } else {
            fontRenderer.func_211126_b(text, (float)(x - fontRenderer.func_78256_a(text) / 2), (float)y, color);
        }
    }

    public void drawRightAlignedString(FontRenderer fontRenderer, String text, int x, int y, int color) {
        if (this.shadow) {
            fontRenderer.func_175063_a(text, (float)(x - fontRenderer.func_78256_a(text)), (float)y, color);
        } else {
            fontRenderer.func_211126_b(text, (float)(x - fontRenderer.func_78256_a(text)), (float)y, color);
        }
    }

    public void drawString(FontRenderer fontRenderer, String text, int x, int y, int color) {
        if (this.shadow) {
            fontRenderer.func_175063_a(text, (float)x, (float)y, color);
        } else {
            fontRenderer.func_211126_b(text, (float)x, (float)y, color);
        }
    }

    public LabelWidget alignRight(boolean align) {
        this.rightAligned = align;
        if (this.rightAligned) {
            this.centered = false;
        }
        return this;
    }

    public void addLine(String string, boolean translate) {
        if (translate) {
            this.addLine(I18n.func_135052_a((String)string, (Object[])new Object[0]));
        } else {
            this.addLine(string);
        }
    }

    public void addLine(String string) {
        this.lines.add(string);
    }

    public void addLine(ITextComponent component) {
        this.lines.add(component.func_150254_d());
    }
}

