/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.gui.spirit;

import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.github.klikli_dev.occultism.client.gui.controls.LabelWidget;
import com.github.klikli_dev.occultism.network.MessageSetManagedMachine;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.util.EnumUtil;
import java.awt.Color;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import org.apache.commons.lang3.StringUtils;

public class BookOfCallingManagedMachineGui
extends Screen {
    protected final String originalCustomName;
    protected String customName;
    protected Direction insertFacing = Direction.UP;
    protected Direction extractFacing = Direction.DOWN;
    protected TextFieldWidget text;

    public BookOfCallingManagedMachineGui(Direction insertFacing, Direction extractFacing, String customName) {
        super((ITextComponent)new StringTextComponent(""));
        this.insertFacing = insertFacing;
        this.extractFacing = extractFacing;
        this.customName = customName == null ? "" : customName;
        this.originalCustomName = this.customName;
        this.init();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.text.render(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void onClose() {
        super.onClose();
        this.text.func_146195_b(false);
        if (!StringUtils.isBlank((CharSequence)this.customName) && !this.customName.equals(this.originalCustomName)) {
            OccultismPackets.sendToServer(new MessageSetManagedMachine(this.makeMachineReference()));
        }
    }

    public void init() {
        super.init();
        this.buttons.clear();
        int guiLeft = this.width / 2;
        int guiTop = (this.height - 166) / 2;
        int buttonWidth = 150;
        int buttonMargin = 5;
        int buttonHeight = 20;
        int buttonTop = 60;
        this.addButton((Widget)new ExtendedButton(guiLeft - buttonWidth / 2, guiTop + buttonTop, buttonWidth, buttonHeight, I18n.func_135052_a((String)("enum.occultism.facing." + this.insertFacing.func_176610_l()), (Object[])new Object[0]), b -> {
            MachineReference reference = this.makeMachineReference();
            this.insertFacing = reference.insertFacing = EnumUtil.nextFacing(this.insertFacing);
            OccultismPackets.sendToServer(new MessageSetManagedMachine(reference));
            this.init();
        }));
        this.addButton((Widget)new ExtendedButton(guiLeft - buttonWidth / 2, guiTop + buttonTop + buttonHeight + buttonMargin, buttonWidth, buttonHeight, I18n.func_135052_a((String)("enum.occultism.facing." + this.extractFacing.func_176610_l()), (Object[])new Object[0]), b -> {
            MachineReference reference = this.makeMachineReference();
            this.extractFacing = reference.extractFacing = EnumUtil.nextFacing(this.extractFacing);
            OccultismPackets.sendToServer(new MessageSetManagedMachine(reference));
            this.init();
        }));
        int textWidth = buttonWidth - 4;
        this.text = new TextFieldWidget(this.font, guiLeft - textWidth / 2, guiTop + buttonTop + buttonHeight * 2 + buttonMargin * 2, textWidth, buttonHeight, "");
        this.text.func_146203_f(30);
        this.text.func_146189_e(true);
        this.text.func_146193_g(Color.WHITE.getRGB());
        this.text.func_146195_b(true);
        this.text.func_146180_a(this.customName);
        int exitButtonSize = 20;
        this.addButton((Widget)new ExtendedButton(guiLeft - exitButtonSize / 2, guiTop + buttonTop + buttonHeight * 3 + buttonMargin * 3, exitButtonSize, exitButtonSize, "X", b -> this.minecraft.func_147108_a(null)));
        LabelWidget insertFacingLabel = new LabelWidget(guiLeft - 80, guiTop + (buttonTop += 5), false, -1, 2, Color.WHITE.getRGB()).alignRight(true);
        insertFacingLabel.addLine("gui.occultism.book_of_calling.manage_machine.insert", true);
        this.addButton(insertFacingLabel);
        LabelWidget extractFacingLabel = new LabelWidget(guiLeft - 80, guiTop + buttonTop + buttonHeight + buttonMargin, false, -1, 2, Color.WHITE.getRGB()).alignRight(true);
        extractFacingLabel.addLine("gui.occultism.book_of_calling.manage_machine.extract", true);
        this.addButton(extractFacingLabel);
        LabelWidget customNameLabel = new LabelWidget(guiLeft - 80, guiTop + buttonTop + buttonHeight * 2 + buttonMargin * 2 + 1, false, -1, 2, Color.WHITE.getRGB()).alignRight(true);
        customNameLabel.addLine("gui.occultism.book_of_calling.manage_machine.custom_name", true);
        this.addButton(customNameLabel);
    }

    public void tick() {
        this.text.func_146178_a();
        super.tick();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.text.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (this.text.keyPressed(keyCode, scanCode, p_keyPressed_3_)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, p_keyPressed_3_);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.text.charTyped(typedChar, keyCode)) {
            this.customName = this.text.func_146179_b();
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    public MachineReference makeMachineReference() {
        MachineReference reference = new MachineReference(null, null, false);
        reference.insertFacing = this.insertFacing;
        reference.extractFacing = this.extractFacing;
        reference.customName = this.customName;
        return reference;
    }
}

