/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render.tile;

import com.github.klikli_dev.occultism.common.block.SpiritAttunedCrystalBlock;
import com.github.klikli_dev.occultism.common.tile.SacrificialBowlTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;

public class SacrificialBowlRenderer
extends TileEntityRenderer<SacrificialBowlTileEntity> {
    public SacrificialBowlRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(SacrificialBowlTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        tileEntity.itemStackHandler.ifPresent(handler -> {
            ItemStack stack = handler.getStackInSlot(0);
            long time = tileEntity.func_145831_w().func_82737_E();
            matrixStack.func_227860_a_();
            double offset = Math.sin(((float)(time - tileEntity.lastChangeTime) + partialTicks) / 16.0f) * 0.5 + 0.5;
            matrixStack.func_227861_a_(0.5, 0.6 + (offset /= 4.0), 0.5);
            float angle = ((float)time + partialTicks) / 16.0f;
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), angle, false));
            float scale = SacrificialBowlRenderer.getScale(stack) * 0.5f;
            matrixStack.func_227862_a_(scale, scale, scale);
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            IBakedModel model = itemRenderer.func_184393_a(stack, tileEntity.func_145831_w(), null);
            itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.FIXED, true, matrixStack, buffer, combinedLight, combinedOverlay, model);
            matrixStack.func_227865_b_();
        });
    }

    public static float getScale(ItemStack stack) {
        BlockItem itemBlock;
        if (stack.func_77973_b() instanceof BlockItem && (itemBlock = (BlockItem)stack.func_77973_b()).func_179223_d() instanceof SpiritAttunedCrystalBlock) {
            return 3.0f;
        }
        return 1.0f;
    }
}

