/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render.tile;

import com.github.klikli_dev.occultism.common.tile.StorageControllerTileEntity;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;

public class StorageControllerRenderer
extends TileEntityRenderer<StorageControllerTileEntity> {
    protected Minecraft minecraft = Minecraft.func_71410_x();
    protected ItemStack stack;

    public StorageControllerRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(StorageControllerTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (this.stack == null) {
            this.stack = new ItemStack((IItemProvider)OccultismItems.DIMENSIONAL_MATRIX.get());
        }
        long time = tileEntity.func_145831_w().func_82737_E();
        matrixStack.func_227860_a_();
        double offset = Math.sin(((float)time + partialTicks) / 8.0f) / 16.0;
        matrixStack.func_227861_a_(0.5, 1.75 + offset, 0.5);
        float angle = ((float)time + partialTicks) / 16.0f;
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), angle, false));
        float scale = (float)(1.0 + Math.sin(((float)time + partialTicks) / 8.0f) * (double)0.025f);
        matrixStack.func_227862_a_(scale, scale, scale);
        long colorScale = 100L - Math.abs(time / 2L % 160L - 80L);
        float saturation = (float)Math.sin(((float)time + partialTicks) / 8.0f) * 0.5f + 0.5f;
        int color = Color.getHSBColor(0.01f * (float)colorScale, saturation, 0.01f * (float)colorScale).getRGB();
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        IBakedModel model = itemRenderer.func_184393_a(this.stack, tileEntity.func_145831_w(), null);
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        RenderType rendertype = RenderTypeLookup.func_228389_a_((ItemStack)this.stack);
        IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)rendertype, (boolean)true, (boolean)this.stack.func_77962_s());
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            this.renderQuads(matrixStack, ivertexbuilder, model.func_200117_a(null, direction, random), color, combinedLight, combinedOverlay);
        }
        random.setSeed(42L);
        this.renderQuads(matrixStack, ivertexbuilder, model.func_200117_a(null, null, random), color, combinedLight, combinedOverlay);
        matrixStack.func_227865_b_();
    }

    public void renderQuads(MatrixStack matrixStackIn, IVertexBuilder bufferIn, List<BakedQuad> quadsIn, int colorIn, int combinedLightIn, int combinedOverlayIn) {
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        for (BakedQuad bakedquad : quadsIn) {
            int i = colorIn;
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            bufferIn.addVertexData(matrixstack$entry, bakedquad, f, f1, f2, combinedLightIn, combinedOverlayIn, true);
        }
    }
}

