/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.block;

import com.github.klikli_dev.occultism.common.tile.SacrificialBowlTileEntity;
import com.github.klikli_dev.occultism.registry.OccultismTiles;
import com.github.klikli_dev.occultism.util.StorageUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SacrificialBowlBlock
extends Block {
    private static final VoxelShape SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0));

    public SacrificialBowlBlock(Block.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            StorageUtil.dropInventoryItems(worldIn.func_175625_s(pos));
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            ItemStack heldItem = player.func_184586_b(hand);
            SacrificialBowlTileEntity bowl = (SacrificialBowlTileEntity)world.func_175625_s(pos);
            bowl.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, hit.func_216354_b()).ifPresent(handler -> {
                if (!player.func_225608_bj_()) {
                    ItemStack itemStack = handler.getStackInSlot(0);
                    if (itemStack.func_190926_b()) {
                        player.func_184611_a(hand, handler.insertItem(0, heldItem, false));
                        world.func_184133_a(null, pos, SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    } else {
                        if (heldItem.func_190926_b()) {
                            player.func_184611_a(hand, handler.extractItem(0, 64, false));
                        } else {
                            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)handler.extractItem(0, 64, false));
                        }
                        world.func_184133_a(null, pos, SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    bowl.func_70296_d();
                }
            });
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)OccultismTiles.SACRIFICIAL_BOWL.get()).func_200968_a();
    }
}

