/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.block.otherworld;

import com.github.klikli_dev.occultism.api.common.data.OtherworldBlockTier;
import com.github.klikli_dev.occultism.api.common.item.IOtherworldTool;
import com.github.klikli_dev.occultism.registry.OccultismEffects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public interface IOtherworldBlock {
    public static final IProperty<Boolean> UNCOVERED = BooleanProperty.func_177716_a((String)"uncovered");

    public Block getUncoveredBlock();

    public Block getCoveredBlock();

    public OtherworldBlockTier getTier();

    default public OtherworldBlockTier getPlayerHarvestTier(PlayerEntity player, ItemStack tool) {
        OtherworldBlockTier effectTier;
        OtherworldBlockTier toolTier = OtherworldBlockTier.NONE;
        OtherworldBlockTier otherworldBlockTier = effectTier = player.func_70644_a((Effect)OccultismEffects.THIRD_EYE.get()) ? OtherworldBlockTier.ONE : OtherworldBlockTier.NONE;
        if (tool.func_77973_b() instanceof IOtherworldTool) {
            toolTier = ((IOtherworldTool)tool.func_77973_b()).getHarvestTier(tool);
        }
        return OtherworldBlockTier.max(toolTier, effectTier);
    }

    default public BlockState getHarvestState(PlayerEntity player, BlockState state, ItemStack tool) {
        return this.getPlayerHarvestTier(player, tool).getLevel() >= this.getTier().getLevel() ? (BlockState)state.func_206870_a(UNCOVERED, (Comparable)Boolean.valueOf(true)) : state;
    }

    default public ItemStack getItem(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)((Boolean)state.func_177229_b(UNCOVERED) != false ? this.getUncoveredBlock() : this.getCoveredBlock()), 1);
    }
}

