/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.block.storage;

import com.github.klikli_dev.occultism.common.tile.StableWormholeTileEntity;
import com.github.klikli_dev.occultism.registry.OccultismTiles;
import com.github.klikli_dev.occultism.util.TileEntityUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class StableWormholeBlock
extends Block {
    public static final Property<Boolean> LINKED = BooleanProperty.func_177716_a((String)"linked");
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.builder().put((Object)Direction.EAST, (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0))).put((Object)Direction.WEST, (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0))).put((Object)Direction.NORTH, (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0))).put((Object)Direction.SOUTH, (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625))).put((Object)Direction.UP, (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0))).put((Object)Direction.DOWN, (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0))).build());

    public StableWormholeBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(LINKED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((IProperty)BlockStateProperties.field_208155_H));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntityUtil.onBlockChangeDropWithNbt(this, state, worldIn, pos, newState);
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult rayTraceResult) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof StableWormholeTileEntity) {
            StableWormholeTileEntity wormhole = (StableWormholeTileEntity)tileEntity;
            if (wormhole.getLinkedStorageController() != null) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)pos);
            } else {
                world.func_180501_a(pos, (BlockState)state.func_206870_a(LINKED, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)context.func_196000_l());
        if (context.func_195996_i().func_196082_o().func_74775_l("BlockEntityTag").func_74764_b("linkedStorageControllerPosition")) {
            state = (BlockState)state.func_206870_a(LINKED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return TileEntityUtil.getItemWithNbt(this, worldIn, pos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{LINKED, BlockStateProperties.field_208155_H});
        super.func_206840_a(builder);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)OccultismTiles.STABLE_WORMHOLE.get()).func_200968_a();
    }
}

