/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.block.storage;

import com.github.klikli_dev.occultism.common.tile.StorageControllerTileEntity;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class StorageStabilizerBlock
extends Block {
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.builder().put((Object)Direction.EAST, (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 0.3, 1.0, 1.0))).put((Object)Direction.WEST, (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.7, 0.0, 0.0, 1.0, 1.0, 1.0))).put((Object)Direction.NORTH, (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.7, 1.0, 1.0, 1.0))).put((Object)Direction.SOUTH, (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.3))).put((Object)Direction.UP, (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3, 1.0))).put((Object)Direction.DOWN, (Object)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.7, 0.0, 1.0, 1.0, 1.0))).build());

    public StorageStabilizerBlock(Block.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((IProperty)BlockStateProperties.field_208155_H));
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state != newState) {
            this.notifyStorageControllers(world, pos, state);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)context.func_196000_l());
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.notifyStorageControllers(world, pos, state);
        super.func_180633_a(world, pos, state, placer, stack);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208155_H});
        super.func_206840_a(builder);
    }

    public void notifyStorageControllers(World world, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.func_177229_b((IProperty)DirectionalBlock.field_176387_N);
        BlockPos min = facing != Direction.DOWN && facing != Direction.UP ? pos.func_177977_b() : pos;
        List<BlockPos> blocks = Math3DUtil.simpleTrace(min, facing, 5);
        for (BlockPos block : blocks) {
            TileEntity tileEntity = world.func_175625_s(block);
            if (!(tileEntity instanceof StorageControllerTileEntity)) continue;
            StorageControllerTileEntity controller = (StorageControllerTileEntity)tileEntity;
            controller.updateStabilizers();
        }
    }
}

