/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.container.storage;

import com.github.klikli_dev.occultism.api.common.tile.IStorageController;
import com.github.klikli_dev.occultism.common.container.storage.StorageControllerContainerBase;
import com.github.klikli_dev.occultism.common.item.storage.StorageRemoteItem;
import com.github.klikli_dev.occultism.common.misc.StorageControllerCraftingInventory;
import com.github.klikli_dev.occultism.network.MessageUpdateLinkedMachines;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismContainers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Hand;

public class StorageRemoteContainer
extends StorageControllerContainerBase {
    protected ItemStack storageRemote;

    public StorageRemoteContainer(int id, PlayerInventory playerInventory) {
        super((ContainerType)OccultismContainers.STORAGE_REMOTE.get(), id, playerInventory);
        this.playerInventory = playerInventory;
        this.storageRemote = playerInventory.field_70458_d.func_184586_b(Hand.MAIN_HAND);
        this.matrix = new StorageControllerCraftingInventory((Container)this, this.getCraftingMatrixFromItemStack(this.getStorageRemote()));
        this.orderInventory.func_70299_a(0, this.getOrderStackFromItemStack(this.getStorageRemote()));
        this.setupCraftingOutput();
        this.setupCraftingGrid();
        this.setupOrderInventorySlot();
        this.setupPlayerInventorySlots();
        this.setupPlayerHotbar();
        this.func_75130_a((IInventory)this.matrix);
    }

    public ItemStack getStorageRemote() {
        return this.storageRemote.func_77973_b() instanceof StorageRemoteItem ? this.storageRemote : ItemStack.field_190927_a;
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.findRecipeForMatrix();
    }

    public void func_190896_a(List<ItemStack> stacks) {
        this.matrix.disableEvents = true;
        super.func_190896_a(stacks);
        this.matrix.disableEvents = false;
    }

    public boolean func_75145_c(PlayerEntity entityPlayer) {
        IStorageController storageController = this.getStorageController();
        if (storageController != null && !entityPlayer.field_70170_p.field_72995_K && entityPlayer.field_70170_p.func_82737_E() % 40L == 0L) {
            OccultismPackets.sendTo((ServerPlayerEntity)this.player, this.getStorageController().getMessageUpdateStacks());
            OccultismPackets.sendTo((ServerPlayerEntity)this.player, new MessageUpdateLinkedMachines(this.getStorageController().getLinkedMachines()));
        }
        return entityPlayer.func_184586_b(Hand.MAIN_HAND) == this.storageRemote;
    }

    @Override
    public IStorageController getStorageController() {
        return StorageRemoteItem.getStorageController(this.getStorageRemote(), this.playerInventory.field_70458_d.field_70170_p);
    }

    @Override
    public boolean isContainerItem() {
        return true;
    }

    @Override
    public void updateCraftingSlots(boolean force) {
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this.matrix.func_70302_i_(); ++i) {
            nbtTagList.add((Object)this.matrix.func_70301_a(i).serializeNBT());
        }
        this.storageRemote.func_196082_o().func_218657_a("craftingMatrix", (INBT)nbtTagList);
    }

    @Override
    public void updateOrderSlot(boolean force) {
        this.storageRemote.func_196082_o().func_218657_a("orderStack", (INBT)this.orderInventory.func_70301_a(0).serializeNBT());
    }

    @Override
    protected void setupPlayerHotbar() {
        int hotbarTop = 232;
        int hotbarLeft = 56;
        for (int i = 0; i < 9; ++i) {
            if (i == this.playerInventory.field_70461_c) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, i, hotbarLeft + i * 18, hotbarTop){

                    public boolean func_75214_a(ItemStack stack) {
                        return false;
                    }

                    public boolean func_75216_d() {
                        return false;
                    }

                    public boolean func_82869_a(PlayerEntity playerIn) {
                        return false;
                    }
                });
            }
            this.func_75146_a(new Slot((IInventory)this.playerInventory, i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    protected List<ItemStack> getCraftingMatrixFromItemStack(ItemStack stack) {
        ArrayList<ItemStack> craftingMatrix = new ArrayList<ItemStack>(Collections.nCopies(9, ItemStack.field_190927_a));
        if (!stack.func_196082_o().func_74764_b("craftingMatrix")) {
            return craftingMatrix;
        }
        ListNBT nbtTagList = stack.func_77978_p().func_150295_c("craftingMatrix", 10);
        for (int i = 0; i < nbtTagList.size(); ++i) {
            craftingMatrix.set(i, ItemStack.func_199557_a((CompoundNBT)nbtTagList.func_150305_b(i)));
        }
        return craftingMatrix;
    }

    protected ItemStack getOrderStackFromItemStack(ItemStack stack) {
        if (!stack.func_196082_o().func_74764_b("orderStack")) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)stack.func_77978_p().func_74775_l("orderStack"));
    }
}

