/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai;

import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.github.klikli_dev.occultism.api.common.tile.IStorageController;
import com.github.klikli_dev.occultism.api.common.tile.IStorageControllerProxy;
import com.github.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.ManageMachineJob;
import com.github.klikli_dev.occultism.common.misc.DepositOrder;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ManageMachineGoal
extends Goal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected BlockPos targetBlock = null;
    protected TileEntity cachedStorageAccessor;
    protected DepositOrder cachedStorageAccessorOrder;
    protected ManageMachineJob job;

    public ManageMachineGoal(SpiritEntity entity, ManageMachineJob job) {
        this.entity = entity;
        this.job = job;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    private BlockPos getMoveTarget() {
        double angle = Math3DUtil.yaw(this.entity.func_174791_d(), Math3DUtil.center(this.targetBlock));
        return this.targetBlock.func_177972_a(Direction.func_176733_a((double)angle).func_176734_d());
    }

    public boolean func_75250_a() {
        if (this.entity.func_70638_az() != null) {
            return false;
        }
        if (!this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.targetBlock != null) {
            if (this.entity.field_70170_p.func_175625_s(this.targetBlock) != null && this.job.getStorageController() != null) {
                float accessDistance;
                TileEntity tileEntity = this.entity.field_70170_p.func_175625_s(this.targetBlock);
                double distance = this.entity.func_174791_d().func_72438_d(Math3DUtil.center(this.targetBlock));
                if (distance < (double)(accessDistance = 1.86f)) {
                    this.entity.func_70661_as().func_75499_g();
                } else {
                    BlockPos moveTarget = this.getMoveTarget();
                    this.entity.func_70661_as().func_75484_a(this.entity.func_70661_as().func_179680_a(moveTarget, 0), 1.0);
                }
                if (distance < (double)accessDistance && this.canSeeTarget()) {
                    DepositOrder currentOrder = this.job.getCurrentDepositOrder();
                    MachineReference machineReference = this.job.getManagedMachine();
                    if (tileEntity instanceof IStorageControllerProxy && currentOrder != null) {
                        ItemStack itemToExtract = this.job.getStorageController().getItemStack(currentOrder.comparator, currentOrder.amount, true);
                        IItemHandler handler = (IItemHandler)this.entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).orElseThrow(ItemHandlerMissingException::new);
                        if (!itemToExtract.func_190926_b() && ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)itemToExtract, (boolean)true).func_190926_b()) {
                            ItemStack extracted = this.job.getStorageController().getItemStack(currentOrder.comparator, currentOrder.amount, false);
                            ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)extracted, (boolean)false);
                            this.entity.setDepositPosition(machineReference.globalPos.getPos());
                            this.entity.setDepositFacing(machineReference.insertFacing);
                            this.job.setCurrentDepositOrder(null);
                            this.targetBlock = null;
                        }
                    } else if (this.targetBlock.equals((Object)machineReference.globalPos.getPos())) {
                        tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, machineReference.extractFacing).ifPresent(machineHandler -> {
                            IItemHandler entityHandler = (IItemHandler)this.entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).orElseThrow(ItemHandlerMissingException::new);
                            boolean movedAnyItems = false;
                            for (int i = 0; i < machineHandler.getSlots(); ++i) {
                                ItemStack itemToExtract = machineHandler.extractItem(i, machineHandler.getSlotLimit(i), true);
                                ItemStack remaining = ItemHandlerHelper.insertItem((IItemHandler)entityHandler, (ItemStack)itemToExtract, (boolean)true);
                                if (itemToExtract.func_190926_b() || remaining.func_190916_E() == itemToExtract.func_190916_E()) continue;
                                ItemStack extracted = machineHandler.extractItem(i, itemToExtract.func_190916_E() - remaining.func_190916_E(), false);
                                ItemHandlerHelper.insertItem((IItemHandler)entityHandler, (ItemStack)extracted, (boolean)false);
                                movedAnyItems = true;
                                if (remaining.func_190916_E() > 0) break;
                            }
                            if (movedAnyItems) {
                                TileEntity storageControllerProxy = this.findClosestStorageProxy();
                                this.entity.setDepositPosition(storageControllerProxy.func_174877_v());
                                this.entity.setDepositFacing(Direction.UP);
                                this.targetBlock = null;
                            }
                        });
                    }
                    this.func_75251_c();
                }
            } else {
                this.func_75251_c();
            }
        }
    }

    public boolean canSeeTarget() {
        BlockState targetBlockState = this.entity.field_70170_p.func_180495_p(this.targetBlock);
        RayTraceContext context = new RayTraceContext(this.entity.func_174824_e(0.0f), Math3DUtil.center(this.targetBlock), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.entity);
        BlockRayTraceResult rayTrace = this.entity.field_70170_p.func_217299_a(context);
        if (rayTrace.func_216346_c() != RayTraceResult.Type.MISS) {
            BlockPos sidePos = rayTrace.func_216350_a();
            BlockPos pos = new BlockPos(rayTrace.func_216347_e());
            return this.entity.field_70170_p.func_175623_d(sidePos) || this.entity.field_70170_p.func_175623_d(pos) || this.entity.field_70170_p.func_175625_s(pos) == this.entity.field_70170_p.func_175625_s(this.targetBlock);
        }
        return true;
    }

    protected TileEntity findClosestStorageProxy() {
        if (this.cachedStorageAccessor != null && this.cachedStorageAccessorOrder == this.job.getCurrentDepositOrder()) {
            return this.cachedStorageAccessor;
        }
        World world = this.entity.field_70170_p;
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        BlockPos machinePosition = this.job.getManagedMachine().globalPos.getPos();
        int workAreaSize = this.entity.getWorkAreaSize().getValue();
        Stream searchBlocks = BlockPos.func_218281_b((BlockPos)machinePosition.func_177982_a(-workAreaSize, -workAreaSize / 2, -workAreaSize), (BlockPos)machinePosition.func_177982_a(workAreaSize, workAreaSize / 2, workAreaSize));
        searchBlocks.forEachOrdered(pos -> {
            IStorageControllerProxy proxy;
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof IStorageControllerProxy && (proxy = (IStorageControllerProxy)tileEntity).getLinkedStorageControllerPosition() != null && proxy.getLinkedStorageControllerPosition().equals(this.job.getStorageControllerPosition())) {
                allBlocks.add(pos.func_185334_h());
            }
        });
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            this.cachedStorageAccessor = world.func_175625_s((BlockPos)allBlocks.get(0));
            this.cachedStorageAccessorOrder = this.job.getCurrentDepositOrder();
            return this.cachedStorageAccessor;
        }
        return null;
    }

    private boolean startTargetingStorageController(DepositOrder depositOrder, MachineReference machineReference, TileEntity machine, IStorageController storageController) {
        return (Boolean)machine.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, machineReference.insertFacing).map(machineItemHandler -> {
            ItemStack orderStack = storageController.getItemStack(depositOrder.comparator, depositOrder.amount, true);
            if (!orderStack.func_190926_b() && ItemHandlerHelper.insertItem((IItemHandler)machineItemHandler, (ItemStack)orderStack, (boolean)true).func_190926_b()) {
                TileEntity storageControllerProxy = this.findClosestStorageProxy();
                if (storageControllerProxy != null) {
                    this.targetBlock = storageControllerProxy.func_174877_v();
                    return true;
                }
                this.targetBlock = null;
                return true;
            }
            if (!orderStack.func_190926_b()) {
                return false;
            }
            return false;
        }).orElse((Object)false);
    }

    private boolean startTargetingMachine(DepositOrder depositOrder, MachineReference machineReference, TileEntity machine, IStorageController storageController) {
        return (Boolean)machine.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, machineReference.extractFacing).map(machineItemHandler -> {
            for (int i = 0; i < machineItemHandler.getSlots(); ++i) {
                if (machineItemHandler.getStackInSlot(i).func_190926_b()) continue;
                this.targetBlock = machine.func_174877_v();
                return true;
            }
            this.targetBlock = null;
            return false;
        }).orElse((Object)false);
    }

    private void resetTarget() {
        DepositOrder currentOrder = this.job.getCurrentDepositOrder();
        MachineReference machineReference = this.job.getManagedMachine();
        TileEntity machine = this.job.getManagedMachineTileEntity();
        IStorageController storageController = this.job.getStorageController();
        if (machine != null && storageController != null) {
            if (!machine.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, machineReference.insertFacing).isPresent() || !machine.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, machineReference.extractFacing).isPresent()) {
                this.job.setManagedMachine(null);
                this.targetBlock = null;
                return;
            }
            if (currentOrder == null || !this.startTargetingStorageController(currentOrder, machineReference, machine, storageController)) {
                this.startTargetingMachine(currentOrder, machineReference, machine, storageController);
            }
        }
    }
}

