/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai;

import com.github.klikli_dev.occultism.common.entity.ai.EntitySorter;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.google.common.base.Predicate;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class PickupItemsGoal
extends TargetGoal {
    protected final SpiritEntity entity;
    protected final Predicate<? super ItemEntity> targetItemSelector;
    protected final EntitySorter entitySorter;
    protected ItemEntity targetItem;
    protected int executionChance;

    public PickupItemsGoal(SpiritEntity entity) {
        this(entity, 10);
    }

    public PickupItemsGoal(final SpiritEntity entity, int executionChance) {
        super((MobEntity)entity, false, false);
        this.entity = entity;
        this.executionChance = executionChance;
        this.targetItemSelector = new Predicate<ItemEntity>(){

            public boolean apply(@Nullable ItemEntity item) {
                ItemStack stack = item.func_92059_d();
                return !stack.func_190926_b() && entity.canPickupItem(stack) && ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)entity.itemStackHandler.orElseThrow(ItemHandlerMissingException::new)), (ItemStack)stack, (boolean)true).func_190916_E() < stack.func_190916_E();
            }
        };
        this.entitySorter = new EntitySorter((Entity)entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        long worldTime = this.field_75299_d.field_70170_p.func_82737_E() % 10L;
        if (this.entity.func_70654_ax() >= 100 && worldTime != 0L) {
            return false;
        }
        if (this.entity.func_70681_au().nextInt(this.executionChance) != 0 && worldTime != 0L) {
            return false;
        }
        int workAreaSize = this.entity.getWorkAreaSize().getValue();
        AxisAlignedBB targetBox = new AxisAlignedBB((double)(-workAreaSize), (double)(-workAreaSize) / 2.0, (double)(-workAreaSize), (double)workAreaSize, (double)workAreaSize / 2.0, (double)workAreaSize).func_186670_a(this.entity.getWorkAreaCenter());
        List list = this.field_75299_d.field_70170_p.func_175647_a(ItemEntity.class, targetBox, this.targetItemSelector);
        if (list.isEmpty()) {
            return false;
        }
        list.sort(this.entitySorter);
        this.targetItem = (ItemEntity)list.get(0);
        return true;
    }

    public void func_75246_d() {
        if (this.targetItem == null || !this.targetItem.func_70089_S()) {
            this.func_75251_c();
            this.field_75299_d.func_70661_as().func_75499_g();
        } else {
            this.field_75299_d.func_70661_as().func_75484_a(this.field_75299_d.func_70661_as().func_75494_a((Entity)this.targetItem, 0), 1.0);
            double distance = this.entity.func_174791_d().func_72438_d(this.targetItem.func_213303_ch());
            if (distance < 1.0) {
                this.entity.func_213293_j(0.0, 0.0, 0.0);
                this.entity.func_70661_as().func_75499_g();
                ItemStack duplicate = this.targetItem.func_92059_d().func_77946_l();
                ItemStackHandler handler = (ItemStackHandler)this.entity.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
                if (ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)duplicate, (boolean)true).func_190916_E() < duplicate.func_190916_E()) {
                    ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)duplicate, (boolean)false);
                    this.targetItem.func_92059_d().func_190920_e(remaining.func_190916_E());
                }
            }
        }
    }

    public boolean func_75253_b() {
        return !this.field_75299_d.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.field_75299_d.func_70661_as().func_75484_a(this.field_75299_d.func_70661_as().func_75494_a((Entity)this.targetItem, 0), 1.0);
        super.func_75249_e();
    }
}

