/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.spirit;

import com.github.klikli_dev.occultism.api.common.data.WorkAreaSize;
import com.github.klikli_dev.occultism.common.container.spirit.SpiritContainer;
import com.github.klikli_dev.occultism.common.entity.ISkinnedCreatureMixin;
import com.github.klikli_dev.occultism.common.item.spirit.BookOfCallingItem;
import com.github.klikli_dev.occultism.common.job.SpiritJob;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.registry.OccultismSounds;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemStackHandler;

public abstract class SpiritEntity
extends TameableEntity
implements ISkinnedCreatureMixin,
INamedContainerProvider {
    public static final DataParameter<Integer> SKIN = EntityDataManager.func_187226_a(SpiritEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final int DEFAULT_MAX_AGE = -1;
    private static final DataParameter<Optional<BlockPos>> DEPOSIT_POSITION = EntityDataManager.func_187226_a(SpiritEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Direction> DEPOSIT_FACING = EntityDataManager.func_187226_a(SpiritEntity.class, (IDataSerializer)DataSerializers.field_187202_l);
    private static final DataParameter<Optional<BlockPos>> EXTRACT_POSITION = EntityDataManager.func_187226_a(SpiritEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Direction> EXTRACT_FACING = EntityDataManager.func_187226_a(SpiritEntity.class, (IDataSerializer)DataSerializers.field_187202_l);
    private static final DataParameter<Optional<BlockPos>> WORK_AREA_POSITION = EntityDataManager.func_187226_a(SpiritEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Integer> WORK_AREA_SIZE = EntityDataManager.func_187226_a(SpiritEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SPIRIT_AGE = EntityDataManager.func_187226_a(SpiritEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SPIRIT_MAX_AGE = EntityDataManager.func_187226_a(SpiritEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> JOB_ID = EntityDataManager.func_187226_a(SpiritEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    public LazyOptional<ItemStackHandler> itemStackHandler = LazyOptional.of(ItemStackHandler::new);
    protected Optional<SpiritJob> job = Optional.empty();
    protected boolean isInitialized = false;

    public SpiritEntity(EntityType<? extends SpiritEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_110163_bv();
    }

    public Optional<BlockPos> getDepositPosition() {
        return (Optional)this.field_70180_af.func_187225_a(DEPOSIT_POSITION);
    }

    public void setDepositPosition(BlockPos position) {
        this.field_70180_af.func_187227_b(DEPOSIT_POSITION, Optional.ofNullable(position));
    }

    public Optional<BlockPos> getExtractPosition() {
        return (Optional)this.field_70180_af.func_187225_a(EXTRACT_POSITION);
    }

    public void setExtractPosition(BlockPos position) {
        this.field_70180_af.func_187227_b(EXTRACT_POSITION, Optional.ofNullable(position));
    }

    public Optional<BlockPos> getWorkAreaPosition() {
        return (Optional)this.field_70180_af.func_187225_a(WORK_AREA_POSITION);
    }

    public void setWorkAreaPosition(BlockPos position) {
        this.field_70180_af.func_187227_b(WORK_AREA_POSITION, Optional.ofNullable(position));
    }

    public WorkAreaSize getWorkAreaSize() {
        return WorkAreaSize.get((Integer)this.field_70180_af.func_187225_a(WORK_AREA_SIZE));
    }

    public void setWorkAreaSize(WorkAreaSize workAreaSize) {
        this.field_70180_af.func_187227_b(WORK_AREA_SIZE, (Object)workAreaSize.getValue());
    }

    public BlockPos getWorkAreaCenter() {
        return this.getWorkAreaPosition().orElse(this.func_180425_c());
    }

    public Direction getDepositFacing() {
        return (Direction)this.field_70180_af.func_187225_a(DEPOSIT_FACING);
    }

    public void setDepositFacing(Direction depositFacing) {
        this.field_70180_af.func_187227_b(DEPOSIT_FACING, (Object)depositFacing);
    }

    public Direction getExtractFacing() {
        return (Direction)this.field_70180_af.func_187225_a(EXTRACT_FACING);
    }

    public void setExtractFacing(Direction extractFacing) {
        this.field_70180_af.func_187227_b(EXTRACT_FACING, (Object)extractFacing);
    }

    public int getSpiritAge() {
        return (Integer)this.field_70180_af.func_187225_a(SPIRIT_AGE);
    }

    public void setSpiritAge(int seconds) {
        this.field_70180_af.func_187227_b(SPIRIT_AGE, (Object)seconds);
    }

    public int getSpiritMaxAge() {
        return (Integer)this.field_70180_af.func_187225_a(SPIRIT_MAX_AGE);
    }

    public void setSpiritMaxAge(int seconds) {
        this.field_70180_af.func_187227_b(SPIRIT_MAX_AGE, (Object)seconds);
    }

    public String getJobID() {
        return (String)this.field_70180_af.func_187225_a(JOB_ID);
    }

    public void setJobID(String id) {
        this.field_70180_af.func_187227_b(JOB_ID, (Object)id);
    }

    public Optional<SpiritJob> getJob() {
        return this.job;
    }

    public void setJob(SpiritJob job) {
        this.removeJob();
        this.job = Optional.ofNullable(job);
        if (job != null) {
            this.job = Optional.ofNullable(job);
            this.setJobID(job.getFactoryID().toString());
        }
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new SpiritContainer(id, playerInventory, this);
    }

    @Override
    public LivingEntity getEntity() {
        return this;
    }

    @Override
    public DataParameter<Integer> getDataParameterSkin() {
        return SKIN;
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.selectRandomSkin();
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (!this.isInitialized) {
                this.isInitialized = true;
                this.init();
            }
            if (this.field_70170_p.func_82737_E() % 20L == 0L && !this.field_70729_aU && this.canDieFromAge()) {
                this.setSpiritAge(this.getSpiritAge() + 1);
                if (this.getSpiritAge() > this.getSpiritMaxAge()) {
                    this.func_70645_a(DamageSource.field_76377_j);
                    this.func_70106_y();
                }
            }
            if (!this.field_70729_aU) {
                this.job.ifPresent(SpiritJob::update);
            }
        }
        this.func_82168_bl();
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        boolean flag;
        ItemStack itemStack = player.func_184586_b(hand);
        boolean bl = flag = !itemStack.func_190926_b();
        if (itemStack.func_190926_b() && this.func_70909_n() && player.func_225608_bj_()) {
            this.openGUI(player);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        switch (slotIn) {
            case MAINHAND: {
                return ((ItemStackHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new)).getStackInSlot(0);
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        switch (slotIn) {
            case MAINHAND: {
                ((ItemStackHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new)).setStackInSlot(0, stack);
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.registerSkinDataParameter();
        this.field_70180_af.func_187214_a(DEPOSIT_POSITION, Optional.empty());
        this.field_70180_af.func_187214_a(DEPOSIT_FACING, (Object)Direction.UP);
        this.field_70180_af.func_187214_a(EXTRACT_POSITION, Optional.empty());
        this.field_70180_af.func_187214_a(EXTRACT_FACING, (Object)Direction.DOWN);
        this.field_70180_af.func_187214_a(WORK_AREA_POSITION, Optional.empty());
        this.field_70180_af.func_187214_a(WORK_AREA_SIZE, (Object)WorkAreaSize.SMALL.getValue());
        this.field_70180_af.func_187214_a(SPIRIT_AGE, (Object)0);
        this.field_70180_af.func_187214_a(SPIRIT_MAX_AGE, (Object)-1);
        this.field_70180_af.func_187214_a(JOB_ID, (Object)"");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("spiritAge", this.getSpiritAge());
        compound.func_74768_a("spiritMaxAge", this.getSpiritMaxAge());
        this.getWorkAreaPosition().ifPresent(pos -> compound.func_74772_a("workAreaPosition", pos.func_218275_a()));
        compound.func_74768_a("workAreaSize", this.getWorkAreaSize().getValue());
        this.getDepositPosition().ifPresent(pos -> compound.func_74772_a("depositPosition", pos.func_218275_a()));
        compound.func_74768_a("depositFacing", this.getDepositFacing().ordinal());
        this.getExtractPosition().ifPresent(pos -> compound.func_74772_a("extractPosition", pos.func_218275_a()));
        compound.func_74768_a("extractFacing", this.getExtractFacing().ordinal());
        this.itemStackHandler.ifPresent(handler -> compound.func_218657_a("inventory", (INBT)handler.serializeNBT()));
        this.job.ifPresent(job -> compound.func_218657_a("spiritJob", (INBT)job.serializeNBT()));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("spiritAge")) {
            this.setSpiritAge(compound.func_74762_e("spiritAge"));
        }
        if (compound.func_74764_b("spiritMaxAge")) {
            this.setSpiritMaxAge(compound.func_74762_e("spiritMaxAge"));
        }
        if (compound.func_74764_b("workAreaPosition")) {
            this.setWorkAreaPosition(BlockPos.func_218283_e((long)compound.func_74763_f("workAreaPosition")));
        }
        if (compound.func_74764_b("workAreaSize")) {
            this.setWorkAreaSize(WorkAreaSize.get(compound.func_74762_e("workAreaSize")));
        }
        if (compound.func_74764_b("depositPosition")) {
            this.setDepositPosition(BlockPos.func_218283_e((long)compound.func_74763_f("depositPosition")));
        }
        if (compound.func_74764_b("depositFacing")) {
            this.setDepositFacing(Direction.values()[compound.func_74762_e("depositFacing")]);
        }
        if (compound.func_74764_b("extractPosition")) {
            this.setExtractPosition(BlockPos.func_218283_e((long)compound.func_74763_f("extractPosition")));
        }
        if (compound.func_74764_b("extractFacing")) {
            this.setExtractFacing(Direction.values()[compound.func_74762_e("extractFacing")]);
        }
        if (compound.func_74764_b("inventory")) {
            this.itemStackHandler.ifPresent(handler -> handler.deserializeNBT(compound.func_74775_l("inventory")));
        }
        if (compound.func_74764_b("spiritJob")) {
            SpiritJob job = SpiritJob.from(this, compound.func_74775_l("spiritJob"));
            this.setJob(job);
        }
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (!tamed) {
            this.setJob(null);
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70909_n()) {
                BookOfCallingItem.spiritDeathRegister.put(this.field_96093_i, this.field_70170_p.func_82737_E());
            }
            this.itemStackHandler.ifPresent(handle -> {
                for (int i = 0; i < handle.getSlots(); ++i) {
                    ItemStack itemstack = handle.getStackInSlot(i);
                    if (itemstack.func_190926_b()) continue;
                    this.func_70099_a(itemstack, 0.0f);
                }
            });
            this.removeJob();
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), (SoundEvent)OccultismSounds.START_RITUAL.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
        super.func_70645_a(cause);
    }

    public void remove(boolean keepData) {
        this.removeJob();
        super.remove(keepData);
    }

    public void removeJob() {
        this.job.ifPresent(SpiritJob::cleanup);
        this.job = Optional.empty();
    }

    public boolean canDieFromAge() {
        return (Integer)this.field_70180_af.func_187225_a(SPIRIT_MAX_AGE) > -1;
    }

    public void init() {
        this.job.ifPresent(SpiritJob::init);
    }

    public boolean canPickupItem(ItemStack stack) {
        return this.job.map(job -> job.canPickupItem(stack)).orElse(false);
    }

    public void openGUI(PlayerEntity playerEntity) {
        if (!this.field_70170_p.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)this, buf -> buf.writeInt(this.func_145782_y()));
        }
    }
}

