/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.spirit;

import com.github.klikli_dev.occultism.common.entity.spirit.WildHuntSkeletonEntity;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.github.klikli_dev.occultism.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class WildHuntWitherSkeletonEntity
extends WitherSkeletonEntity {
    public static final ResourceLocation wildHuntTag = new ResourceLocation("occultism", "wild_hunt");
    List<WildHuntSkeletonEntity> minions = new ArrayList<WildHuntSkeletonEntity>();

    public WildHuntWitherSkeletonEntity(EntityType<? extends WildHuntWitherSkeletonEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        int maxSkeletons = 3 + world.func_201674_k().nextInt(6);
        for (int i = 0; i < maxSkeletons; ++i) {
            WildHuntSkeletonEntity entity = (WildHuntSkeletonEntity)((EntityType)OccultismEntities.WILD_HUNT_SKELETON.get()).func_200721_a(this.field_70170_p);
            entity.func_213386_a(world, difficultyIn, reason, spawnDataIn, dataTag);
            double offsetX = (world.func_201674_k().nextGaussian() - 1.0) * (double)(1 + world.func_201674_k().nextInt(4));
            double offsetZ = (world.func_201674_k().nextGaussian() - 1.0) * (double)(1 + world.func_201674_k().nextInt(4));
            entity.func_70080_a(this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 1.5, this.func_226281_cx_() + offsetZ, world.func_201674_k().nextInt(360), 0.0f);
            entity.func_200203_b((ITextComponent)new StringTextComponent(TextUtil.generateName()));
            world.func_217376_c((Entity)entity);
            entity.setMaster(this);
            this.minions.add(entity);
        }
        return super.func_213386_a(world, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
    }

    protected boolean func_225511_J_() {
        return false;
    }

    protected boolean func_204609_dp() {
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        Tag wildHuntTags = EntityTypeTags.func_219762_a().func_199915_b(wildHuntTag);
        Entity trueSource = source.func_76346_g();
        if (trueSource != null && wildHuntTags.func_199685_a_((Object)trueSource.func_200600_R())) {
            return true;
        }
        Entity immediateSource = source.func_76364_f();
        if (immediateSource != null && wildHuntTags.func_199685_a_((Object)immediateSource.func_200600_R())) {
            return true;
        }
        return super.func_180431_b(source);
    }

    public boolean func_190530_aW() {
        return !this.minions.isEmpty() || super.func_190530_aW();
    }

    public void notifyMinionDeath(WildHuntSkeletonEntity minion) {
        this.minions.remove((Object)minion);
    }
}

