/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.item.spirit;

import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.github.klikli_dev.occultism.api.common.data.WorkAreaSize;
import com.github.klikli_dev.occultism.api.common.item.IHandleItemMode;
import com.github.klikli_dev.occultism.api.common.item.IIngredientCopyNBT;
import com.github.klikli_dev.occultism.api.common.item.IIngredientPreventCrafting;
import com.github.klikli_dev.occultism.api.common.tile.IStorageController;
import com.github.klikli_dev.occultism.client.gui.GuiHelper;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.item.spirit.BookOfBindingBoundItem;
import com.github.klikli_dev.occultism.common.job.ManageMachineJob;
import com.github.klikli_dev.occultism.util.EntityUtil;
import com.github.klikli_dev.occultism.util.ItemNBTUtil;
import com.github.klikli_dev.occultism.util.TextUtil;
import com.github.klikli_dev.occultism.util.TileEntityUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class BookOfCallingItem
extends Item
implements IIngredientPreventCrafting,
IIngredientCopyNBT,
IHandleItemMode {
    public static Map<UUID, Long> spiritDeathRegister = new HashMap<UUID, Long>();
    public String translationKeyBase;

    public BookOfCallingItem(Item.Properties properties, String translationKeyBase) {
        super(properties);
        this.translationKeyBase = translationKeyBase;
    }

    public String getTranslationKeyBase() {
        return this.translationKeyBase;
    }

    @Override
    public boolean shouldCopyNBT(ItemStack itemStack, IRecipe recipe, CraftingInventory inventory) {
        return recipe.func_77571_b().func_77973_b() instanceof BookOfBindingBoundItem;
    }

    @Override
    public CompoundNBT overrideNBT(ItemStack itemStack, CompoundNBT nbt, IRecipe recipe, CraftingInventory inventory) {
        CompoundNBT result = new CompoundNBT();
        if (nbt.func_74764_b("spiritName")) {
            result.func_74778_a("spiritName", nbt.func_74779_i("spiritName"));
        }
        return result;
    }

    @Override
    public boolean shouldPreventCrafting(ItemStack itemStack, IRecipe recipe, CraftingInventory inventory, World world) {
        CompoundNBT entityNBT = ItemNBTUtil.getSpiritEntityData(itemStack);
        if (entityNBT != null) {
            return true;
        }
        UUID entityUUID = ItemNBTUtil.getSpiritEntityUUID(itemStack);
        MinecraftServer server = world.func_73046_m();
        return entityUUID != null && EntityUtil.getEntityByUuiDGlobal(server, entityUUID).isPresent();
    }

    @Override
    public int getItemMode(ItemStack stack) {
        return ItemNBTUtil.getItemMode(stack);
    }

    @Override
    public void setItemMode(ItemStack stack, int mode) {
        ItemNBTUtil.setItemMode(stack, mode);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        ItemStack itemStack = context.func_195996_i();
        World world = context.func_195991_k();
        Direction facing = context.func_196000_l();
        BlockPos pos = context.func_195995_a();
        CompoundNBT entityData = ItemNBTUtil.getSpiritEntityData(itemStack);
        if (entityData != null) {
            if (!world.field_72995_K) {
                EntityType<?> type = EntityUtil.entityTypeFromNbt(entityData);
                facing = facing == null ? Direction.UP : facing;
                BlockPos spawnPos = pos.func_185334_h();
                if (!world.func_180495_p(spawnPos).func_196952_d((IBlockReader)world, spawnPos).func_197766_b()) {
                    spawnPos = spawnPos.func_177972_a(facing);
                }
                ITextComponent customName = null;
                if (entityData.func_74764_b("CustomName")) {
                    customName = ITextComponent.Serializer.func_150699_a((String)entityData.func_74779_i("CustomName"));
                }
                entityData.func_82580_o("Pos");
                CompoundNBT wrapper = new CompoundNBT();
                wrapper.func_218657_a("EntityTag", (INBT)entityData);
                SpiritEntity entity = (SpiritEntity)type.func_220342_a(world, wrapper, customName, null, spawnPos, SpawnReason.MOB_SUMMONED, true, !pos.equals((Object)spawnPos) && facing == Direction.UP);
                if (entityData.func_74764_b("OwnerUUID") && !entityData.func_74779_i("OwnerUUID").isEmpty()) {
                    entity.func_184754_b(UUID.fromString(entityData.func_74779_i("OwnerUUID")));
                }
                ItemNBTUtil.updateItemNBTFromEntity(itemStack, entity);
                world.func_217376_c((Entity)entity);
                itemStack.func_77978_p().func_82580_o("spiritData");
                player.field_71069_bz.func_75142_b();
            }
        } else {
            if (player.func_225608_bj_()) {
                return this.handleItemMode(player, world, pos, itemStack, facing);
            }
            if (world.field_72995_K) {
                IItemModeSubset<?> subset = this.getItemModeSubset(itemStack);
                WorkAreaSize workAreaSize = ItemNBTUtil.getWorkAreaSize(itemStack);
                GuiHelper.openBookOfCallingGui(subset, workAreaSize);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (target.field_70170_p.field_72995_K) {
            return false;
        }
        if (!(target instanceof SpiritEntity)) {
            return false;
        }
        SpiritEntity entitySpirit = (SpiritEntity)target;
        if (!entitySpirit.func_110124_au().equals(ItemNBTUtil.getSpiritEntityUUID(stack))) {
            if (player.func_184812_l_()) {
                ItemNBTUtil.setSpiritEntityUUID(stack, entitySpirit.func_110124_au());
                ItemNBTUtil.setBoundSpiritName(stack, entitySpirit.func_200200_C_().func_150254_d());
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("item.occultism.book_of_calling.message_target_uuid_no_match", new Object[0]), true);
                return false;
            }
        }
        ItemNBTUtil.setSpiritEntityData(stack, entitySpirit.serializeNBT());
        player.func_184609_a(hand);
        player.func_184611_a(hand, stack);
        entitySpirit.remove(true);
        player.field_71069_bz.func_75142_b();
        return true;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        Long deathTime;
        UUID spiritID;
        if (worldIn.func_82737_E() % 1200L == 0L && (spiritID = ItemNBTUtil.getSpiritEntityUUID(stack)) != null && (deathTime = spiritDeathRegister.get(spiritID)) != null && deathTime < worldIn.func_82737_E()) {
            spiritDeathRegister.remove(spiritID);
            stack.func_77978_p().func_82580_o("spiritUUID");
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent(this.getTranslationKeyBase() + (ItemNBTUtil.getSpiritEntityUUID(stack) != null ? ".tooltip" : ".tooltip_dead"), new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(stack))}));
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemNBTUtil.getSpiritEntityData(stack) != null;
    }

    public Rarity func_77613_e(ItemStack stack) {
        return ItemNBTUtil.getSpiritEntityUUID(stack) != null ? Rarity.RARE : Rarity.COMMON;
    }

    public IItemModeSubset<?> getItemModeSubset(ItemStack stack) {
        return ItemMode.get(this.getItemMode(stack));
    }

    public boolean useWorkAreaSize() {
        return true;
    }

    public boolean setSpiritManagedMachine(PlayerEntity player, World world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.func_73046_m(), boundSpiritId).map(e -> (SpiritEntity)e);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (boundSpirit.isPresent() && tileEntity != null) {
                if (boundSpirit.get().getJob().isPresent() && boundSpirit.get().getJob().get() instanceof ManageMachineJob) {
                    ManageMachineJob manageMachine = (ManageMachineJob)boundSpirit.get().getJob().get();
                    MachineReference newReference = MachineReference.from(tileEntity);
                    if (manageMachine.getManagedMachine() == null || !manageMachine.getManagedMachine().globalPos.equals(newReference.globalPos)) {
                        manageMachine.setManagedMachine(newReference);
                    } else {
                        manageMachine.getManagedMachine().registryName = newReference.registryName;
                    }
                    ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("item.occultism.book_of_calling.message_set_managed_machine", new Object[]{TextUtil.formatDemonName(boundSpirit.get().func_200200_C_().func_150254_d())}), true);
                    return true;
                }
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("item.occultism.book_of_calling.message_spirit_not_found", new Object[0]), true);
            }
        }
        return false;
    }

    public boolean setSpiritStorageController(PlayerEntity player, World world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.func_73046_m(), boundSpiritId).map(e -> (SpiritEntity)e);
            if (boundSpirit.isPresent() && boundSpirit.get().getJob().isPresent()) {
                if (boundSpirit.get().getJob().get() instanceof ManageMachineJob) {
                    ManageMachineJob job = (ManageMachineJob)boundSpirit.get().getJob().get();
                    job.setStorageControllerPosition(new GlobalBlockPos(pos, world));
                    ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                    String blockName = world.func_180495_p(pos).func_177230_c().func_149739_a();
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("item.occultism.book_of_calling.message_set_storage_controller", new Object[]{TextUtil.formatDemonName(boundSpirit.get().func_200200_C_().func_150254_d()), new TranslationTextComponent(blockName, new Object[0])}), true);
                    return true;
                }
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("item.occultism.book_of_calling.message_spirit_not_found", new Object[0]), true);
            }
        }
        return false;
    }

    public boolean setSpiritDepositLocation(PlayerEntity player, World world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.func_73046_m(), boundSpiritId).map(e -> (SpiritEntity)e);
            if (boundSpirit.isPresent()) {
                boundSpirit.get().setDepositPosition(pos);
                boundSpirit.get().setDepositFacing(face);
                ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                String blockName = world.func_180495_p(pos).func_177230_c().func_149739_a();
                player.func_146105_b((ITextComponent)new TranslationTextComponent("item.occultism.book_of_calling.message_set_deposit", new Object[]{TextUtil.formatDemonName(boundSpirit.get().func_200200_C_().func_150254_d()), new TranslationTextComponent(blockName, new Object[0]), face.func_176610_l()}), true);
                return true;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("item.occultism.book_of_calling.message_spirit_not_found", new Object[0]), true);
        }
        return false;
    }

    public boolean setSpiritExtractLocation(PlayerEntity player, World world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.func_73046_m(), boundSpiritId).map(e -> (SpiritEntity)e);
            if (boundSpirit.isPresent()) {
                boundSpirit.get().setExtractPosition(pos);
                boundSpirit.get().setExtractFacing(face);
                ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                String blockName = world.func_180495_p(pos).func_177230_c().func_149739_a();
                player.func_146105_b((ITextComponent)new TranslationTextComponent("item.occultism.book_of_calling.message_set_extract", new Object[]{TextUtil.formatDemonName(boundSpirit.get().func_200200_C_().func_150254_d()), new TranslationTextComponent(blockName, new Object[0]), face.func_176610_l()}), true);
                return true;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("item.occultism.book_of_calling.message_spirit_not_found", new Object[0]), true);
        }
        return false;
    }

    public boolean setSpiritBaseLocation(PlayerEntity player, World world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.func_73046_m(), boundSpiritId).map(e -> (SpiritEntity)e);
            if (boundSpirit.isPresent()) {
                boundSpirit.get().setWorkAreaPosition(pos);
                ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                String blockName = world.func_180495_p(pos).func_177230_c().func_149739_a();
                player.func_146105_b((ITextComponent)new TranslationTextComponent("item.occultism.book_of_calling.message_set_base", new Object[]{TextUtil.formatDemonName(boundSpirit.get().func_200200_C_().func_150254_d()), new TranslationTextComponent(blockName, new Object[0])}), true);
                return true;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("item.occultism.book_of_calling.message_spirit_not_found", new Object[0]), true);
        }
        return false;
    }

    public ActionResultType handleItemMode(PlayerEntity player, World world, BlockPos pos, ItemStack stack, Direction facing) {
        ItemMode itemMode = ItemMode.get(this.getItemMode(stack));
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!world.field_72995_K) {
            switch (itemMode) {
                case SET_DEPOSIT: {
                    if (tileEntity == null || !tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).isPresent()) break;
                    return this.setSpiritDepositLocation(player, world, pos, stack, facing) ? ActionResultType.SUCCESS : ActionResultType.PASS;
                }
                case SET_EXTRACT: {
                    if (tileEntity == null || !tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).isPresent()) break;
                    return this.setSpiritExtractLocation(player, world, pos, stack, facing) ? ActionResultType.SUCCESS : ActionResultType.PASS;
                }
                case SET_BASE: {
                    return this.setSpiritBaseLocation(player, world, pos, stack, facing) ? ActionResultType.SUCCESS : ActionResultType.PASS;
                }
                case SET_STORAGE_CONTROLLER: {
                    if (tileEntity instanceof IStorageController) {
                        return this.setSpiritStorageController(player, world, pos, stack, facing) ? ActionResultType.SUCCESS : ActionResultType.PASS;
                    }
                }
                case SET_MANAGED_MACHINE: {
                    if (tileEntity == null || !TileEntityUtil.hasCapabilityOnAnySide(tileEntity, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) break;
                    this.setSpiritManagedMachine(player, world, pos, stack, facing);
                    return ActionResultType.SUCCESS;
                }
            }
        } else {
            switch (itemMode) {
                case SET_MANAGED_MACHINE: {
                    MachineReference machine;
                    if (tileEntity == null || !TileEntityUtil.hasCapabilityOnAnySide(tileEntity, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) || (machine = ItemNBTUtil.getManagedMachine(stack)) == null) break;
                    GuiHelper.openBookOfCallingManagedMachineGui(machine.insertFacing, machine.extractFacing, machine.customName);
                }
            }
        }
        return ActionResultType.PASS;
    }

    public static interface IItemModeSubset<T extends IItemModeSubset<T>> {
        public ItemMode getItemMode();

        public T next();
    }

    public static enum ItemMode implements IItemModeSubset<ItemMode>
    {
        SET_DEPOSIT(0, "set_deposit"),
        SET_EXTRACT(1, "set_extract"),
        SET_BASE(2, "set_base"),
        SET_STORAGE_CONTROLLER(3, "set_storage_controller"),
        SET_MANAGED_MACHINE(4, "set_managed_machine");

        private static final Map<Integer, ItemMode> lookup;
        private static final String TRANSLATION_KEY_BASE = "enum.occultism.book_of_calling.item_mode";
        private int value;
        private String translationKey;

        private ItemMode(int value, String translationKey) {
            this.value = value;
            this.translationKey = "enum.occultism.book_of_calling.item_mode." + translationKey;
        }

        public int getValue() {
            return this.value;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        @Override
        public ItemMode getItemMode() {
            return this;
        }

        @Override
        public ItemMode next() {
            return ItemMode.values()[(this.ordinal() + 1) % ItemMode.values().length];
        }

        public static ItemMode get(int value) {
            return lookup.get(value);
        }

        public boolean equals(int value) {
            return this.value == value;
        }

        static {
            lookup = new HashMap<Integer, ItemMode>();
            for (ItemMode itemMode : ItemMode.values()) {
                lookup.put(itemMode.getValue(), itemMode);
            }
        }
    }
}

