/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.item.storage;

import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.api.common.tile.IStorageController;
import com.github.klikli_dev.occultism.common.container.storage.StorageRemoteContainer;
import com.github.klikli_dev.occultism.util.TileEntityUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class StorageRemoteItem
extends Item
implements INamedContainerProvider {
    public StorageRemoteItem(Item.Properties properties) {
        super(properties);
        this.func_185043_a(new ResourceLocation("occultism", "linked"), (stack, world, entity) -> stack.func_196082_o().func_74764_b("linkedStorageController") ? 1.0f : 0.0f);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_77658_a(), new Object[0]);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195991_k().field_72995_K) {
            ItemStack stack = context.func_195996_i();
            TileEntity tileEntity = context.func_195991_k().func_175625_s(context.func_195995_a());
            if (tileEntity instanceof IStorageController) {
                stack.func_77983_a("linkedStorageController", (INBT)GlobalBlockPos.from(tileEntity).serializeNBT());
                context.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".message.linked", new Object[0]));
            }
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K || !stack.func_196082_o().func_74764_b("linkedStorageController")) {
            return super.func_77659_a(world, player, hand);
        }
        GlobalBlockPos storageControllerPos = GlobalBlockPos.from(stack.func_77978_p().func_74775_l("linkedStorageController"));
        ServerWorld storageControllerWorld = world.func_73046_m().func_71218_a(storageControllerPos.getDimensionType());
        if (!storageControllerWorld.func_175667_e(storageControllerPos.getPos())) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".message.not_loaded", new Object[0]));
            return super.func_77659_a(world, player, hand);
        }
        if (storageControllerWorld.func_175625_s(storageControllerPos.getPos()) instanceof IStorageController) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip", new Object[0]));
        if (stack.func_196082_o().func_74764_b("linkedStorageController")) {
            GlobalBlockPos pos = GlobalBlockPos.from(stack.func_77978_p().func_74775_l("linkedStorageController"));
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip.linked", new Object[]{pos.toString()}));
        }
    }

    public Rarity func_77613_e(ItemStack stack) {
        return stack.func_196082_o().func_74764_b("linkedStorageController") ? Rarity.RARE : Rarity.COMMON;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new StorageRemoteContainer(id, playerInventory);
    }

    public static IStorageController getStorageController(ItemStack stack, World world) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (!stack.func_196082_o().func_74764_b("linkedStorageController")) {
            return null;
        }
        GlobalBlockPos globalPos = GlobalBlockPos.from(stack.func_77978_p().func_74775_l("linkedStorageController"));
        TileEntity tileEntity = TileEntityUtil.get(world, globalPos);
        return tileEntity instanceof IStorageController ? (IStorageController)tileEntity : null;
    }
}

