/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.item.tool;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.client.divination.ScanManager;
import com.github.klikli_dev.occultism.common.block.otherworld.IOtherworldBlock;
import com.github.klikli_dev.occultism.network.MessageSetDivinationResult;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismSounds;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class DivinationRodItem
extends Item {
    public static final float NOT_FOUND = 7.0f;
    public static final float SEARCHING = 8.0f;

    public DivinationRodItem(Item.Properties properties) {
        super(properties);
        this.func_185043_a(new ResourceLocation("occultism", "distance"), (stack, world, entity) -> {
            if (!stack.func_196082_o().func_74764_b("distance") || stack.func_77978_p().func_74760_g("distance") < 0.0f) {
                return 7.0f;
            }
            return stack.func_77978_p().func_74760_g("distance");
        });
    }

    public void onUsingTick(ItemStack stack, LivingEntity entityLiving, int count) {
        if (entityLiving.field_70170_p.field_72995_K && entityLiving instanceof PlayerEntity) {
            ScanManager.instance.updateScan((PlayerEntity)entityLiving, false);
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockState state;
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = context.func_195996_i();
        if (player.func_225608_bj_() && !(state = world.func_180495_p(pos)).func_177230_c().isAir(state, (IBlockReader)world, pos)) {
            Block block = this.getOtherBlock(state);
            if (block != null) {
                if (!world.field_72995_K) {
                    String translationKey = block instanceof IOtherworldBlock ? ((IOtherworldBlock)block).getUncoveredBlock().func_149739_a() : block.func_149739_a();
                    stack.func_196082_o().func_74778_a("linkedBlockId", block.getRegistryName().toString());
                    player.func_145747_a((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".message.linked_block", new Object[]{new TranslationTextComponent(translationKey, new Object[0])}));
                }
                world.func_184133_a(player, player.func_180425_c(), (SoundEvent)OccultismSounds.TUNING_FORK.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            } else if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".message.no_link_found", new Object[0]));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_225608_bj_()) {
            if (stack.func_196082_o().func_74764_b("linkedBlockId")) {
                stack.func_77978_p().func_74776_a("distance", 8.0f);
                player.func_184598_c(hand);
                world.func_184133_a(player, player.func_180425_c(), (SoundEvent)OccultismSounds.TUNING_FORK.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (world.field_72995_K) {
                    ResourceLocation id = new ResourceLocation(stack.func_77978_p().func_74779_i("linkedBlockId"));
                    ScanManager.instance.beginScan(player, (Block)ForgeRegistries.BLOCKS.getValue(id));
                }
            } else if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".message.no_linked_block", new Object[0]));
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entityLiving) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return stack;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        player.func_184811_cZ().func_185145_a((Item)this, 40);
        stack.func_196082_o().func_74776_a("distance", 7.0f);
        if (world.field_72995_K) {
            BlockPos result = ScanManager.instance.finishScan(player);
            float distance = this.getDistance(player.func_174791_d(), result);
            stack.func_77978_p().func_74776_a("distance", distance);
            OccultismPackets.sendToServer(new MessageSetDivinationResult(distance));
            if (result != null && player.func_184812_l_()) {
                Occultism.SELECTED_BLOCK_RENDERER.selectBlock(result, System.currentTimeMillis() + 10000L);
            }
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entityLiving, int timeLeft) {
        stack.func_196082_o().func_74776_a("distance", 7.0f);
        if (world.field_72995_K) {
            ScanManager.instance.cancelScan();
        }
        super.func_77615_a(stack, world, entityLiving, timeLeft);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_196082_o().func_74764_b("linkedBlockId")) {
            ResourceLocation id = new ResourceLocation(stack.func_77978_p().func_74779_i("linkedBlockId"));
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
            String translationKey = block instanceof IOtherworldBlock ? ((IOtherworldBlock)block).getUncoveredBlock().func_149739_a() : block.func_149739_a();
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip.linked_block", new Object[]{new TranslationTextComponent(translationKey, new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.ITALIC})}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip.no_linked_block", new Object[0]));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public Block getOtherBlock(BlockState state) {
        if (state.func_177230_c() == Blocks.field_196656_g || state.func_177230_c() == OccultismBlocks.OTHERSTONE_NATURAL.get() || state.func_177230_c() == OccultismBlocks.OTHERSTONE.get()) {
            return (Block)OccultismBlocks.OTHERSTONE_NATURAL.get();
        }
        if (state.func_177230_c() == Blocks.field_196617_K || state.func_177230_c() == OccultismBlocks.OTHERWORLD_LOG_NATURAL.get() || state.func_177230_c() == OccultismBlocks.OTHERWORLD_LOG.get()) {
            return (Block)OccultismBlocks.OTHERWORLD_LOG_NATURAL.get();
        }
        if (state.func_177230_c() == Blocks.field_196642_W || state.func_177230_c() == OccultismBlocks.OTHERWORLD_LEAVES_NATURAL.get() || state.func_177230_c() == OccultismBlocks.OTHERWORLD_LEAVES.get()) {
            return (Block)OccultismBlocks.OTHERWORLD_LEAVES_NATURAL.get();
        }
        if (state.func_177230_c() == Blocks.field_150424_aL || state.func_177230_c() == OccultismBlocks.IESNIUM_ORE_NATURAL.get() || state.func_177230_c() == OccultismBlocks.IESNIUM_ORE.get()) {
            return (Block)OccultismBlocks.IESNIUM_ORE_NATURAL.get();
        }
        return null;
    }

    public float getDistance(Vec3d playerPosition, BlockPos result) {
        if (result == null) {
            return 7.0f;
        }
        Vec3d resultCenter = Math3DUtil.center(result);
        Vec3d playerPosition2d = new Vec3d(playerPosition.field_72450_a, 0.0, playerPosition.field_72449_c);
        Vec3d resultCenter2d = new Vec3d(resultCenter.field_72450_a, 0.0, resultCenter.field_72449_c);
        double distance = playerPosition2d.func_72438_d(resultCenter2d);
        if (distance < 6.0) {
            return 0.0f;
        }
        if (distance < 15.0) {
            return 1.0f;
        }
        if (distance < 25.0) {
            return 2.0f;
        }
        if (distance < 35.0) {
            return 3.0f;
        }
        if (distance < 45.0) {
            return 4.0f;
        }
        if (distance < 65.0) {
            return 5.0f;
        }
        return 6.0f;
    }
}

