/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.item.tool;

import com.github.klikli_dev.occultism.api.common.item.IIngredientPreserve;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class GuideBookItem
extends Item
implements IIngredientPreserve {
    public static final ResourceLocation GUIDE = new ResourceLocation("occultism", "dictionary_of_spirits");

    public GuideBookItem(Item.Properties properties) {
        super(properties);
        this.func_185043_a(new ResourceLocation("completion"), new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
                Book book = (Book)BookRegistry.INSTANCE.books.get(GUIDE);
                float progression = 0.0f;
                if (book != null) {
                    int totalEntries = 0;
                    int unlockedEntries = 0;
                    for (BookEntry entry : book.contents.entries.values()) {
                        if (entry.isSecret()) continue;
                        ++totalEntries;
                        if (entry.isLocked()) continue;
                        ++unlockedEntries;
                    }
                    progression = (float)unlockedEntries / Math.max(1.0f, (float)totalEntries);
                }
                return progression;
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K) {
            PatchouliAPI.instance.openBookGUI((ServerPlayerEntity)playerIn, GUIDE);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Book book = (Book)BookRegistry.INSTANCE.books.get(GUIDE);
        if (book != null && book.contents != null) {
            tooltip.add(new StringTextComponent(book.contents.getSubtitle()).func_211708_a(TextFormatting.GRAY));
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        Book book = (Book)BookRegistry.INSTANCE.books.get(GUIDE);
        return book != null ? new TranslationTextComponent(book.name, new Object[0]) : super.func_200295_i(stack);
    }

    @Override
    public boolean shouldPreserve(ItemStack itemStack, IRecipe<?> recipe, CraftingInventory inventory) {
        return true;
    }
}

