/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.item.tool;

import com.github.klikli_dev.occultism.util.EntityUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SoulGemItem
extends Item {
    public SoulGemItem(Item.Properties properties) {
        super(properties);
        this.func_185043_a(new ResourceLocation("occultism", "has_entity"), (stack, world, entity) -> stack.func_196082_o().func_74764_b("entityData") ? 1.0f : 0.0f);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        ItemStack itemStack = context.func_195996_i();
        World world = context.func_195991_k();
        Direction facing = context.func_196000_l();
        BlockPos pos = context.func_195995_a();
        if (itemStack.func_196082_o().func_74764_b("entityData")) {
            if (!world.field_72995_K) {
                CompoundNBT entityData = itemStack.func_77978_p().func_74775_l("entityData");
                itemStack.func_77978_p().func_82580_o("entityData");
                EntityType<?> type = EntityUtil.entityTypeFromNbt(entityData);
                facing = facing == null ? Direction.UP : facing;
                BlockPos spawnPos = pos.func_185334_h();
                if (!world.func_180495_p(spawnPos).func_196952_d((IBlockReader)world, spawnPos).func_197766_b()) {
                    spawnPos = spawnPos.func_177972_a(facing);
                }
                ITextComponent customName = null;
                if (entityData.func_74764_b("CustomName")) {
                    customName = ITextComponent.Serializer.func_150699_a((String)entityData.func_74779_i("CustomName"));
                }
                entityData.func_82580_o("Pos");
                CompoundNBT wrapper = new CompoundNBT();
                wrapper.func_218657_a("EntityTag", (INBT)entityData);
                Entity entity = type.func_220342_a(world, wrapper, customName, null, spawnPos, SpawnReason.MOB_SUMMONED, true, !pos.equals((Object)spawnPos) && facing == Direction.UP);
                if (entity instanceof TameableEntity && entityData.func_74764_b("OwnerUUID") && !entityData.func_74779_i("OwnerUUID").isEmpty()) {
                    TameableEntity tameableEntity = (TameableEntity)entity;
                    try {
                        tameableEntity.func_184754_b(UUID.fromString(entityData.func_74779_i("OwnerUUID")));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                player.func_184609_a(context.func_221531_n());
                player.field_71069_bz.func_75142_b();
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (target.field_70170_p.field_72995_K) {
            return false;
        }
        if (!target.func_184222_aU() || target instanceof PlayerEntity) {
            return false;
        }
        if (stack.func_196082_o().func_74764_b("entityData")) {
            return false;
        }
        stack.func_77978_p().func_218657_a("entityData", (INBT)target.serializeNBT());
        player.func_184609_a(hand);
        player.func_184611_a(hand, stack);
        target.remove(true);
        player.field_71069_bz.func_75142_b();
        return true;
    }

    public String func_77667_c(ItemStack stack) {
        return stack.func_196082_o().func_74764_b("entityData") ? this.func_77658_a() : this.func_77658_a() + "_empty";
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_196082_o().func_74764_b("entityData")) {
            EntityType<?> type = EntityUtil.entityTypeFromNbt(stack.func_77978_p().func_74775_l("entityData"));
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip_filled", new Object[]{type.func_212546_e()}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip_empty", new Object[0]));
        }
    }
}

