/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.job;

import com.github.klikli_dev.occultism.api.common.container.IItemStackComparator;
import com.github.klikli_dev.occultism.common.entity.ai.DepositItemsGoal;
import com.github.klikli_dev.occultism.common.entity.ai.FellTreesGoal;
import com.github.klikli_dev.occultism.common.entity.ai.PickupItemsGoal;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.SpiritJob;
import com.github.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.github.klikli_dev.occultism.common.misc.ItemTagComparator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;

public class LumberjackJob
extends SpiritJob {
    protected PickupItemsGoal pickupItemsGoal;
    protected FellTreesGoal fellTreesGoal;
    protected DepositItemsGoal depositItemsGoal;
    protected List<IItemStackComparator> itemsToPickUp = new ArrayList<IItemStackComparator>();

    public LumberjackJob(SpiritEntity entity) {
        super(entity);
    }

    @Override
    public void init() {
        this.pickupItemsGoal = new PickupItemsGoal(this.entity);
        this.entity.field_70715_bh.func_75776_a(0, (Goal)this.pickupItemsGoal);
        this.fellTreesGoal = new FellTreesGoal(this.entity);
        this.entity.field_70714_bg.func_75776_a(3, (Goal)this.fellTreesGoal);
        this.depositItemsGoal = new DepositItemsGoal(this.entity);
        this.entity.field_70714_bg.func_75776_a(4, (Goal)this.depositItemsGoal);
        this.itemsToPickUp.add(new ItemTagComparator((Tag<Item>)ItemTags.field_200038_h));
        this.itemsToPickUp.add(new ItemTagComparator((Tag<Item>)ItemTags.field_206963_E));
        this.itemsToPickUp.add(new ItemTagComparator((Tag<Item>)ItemTags.field_200037_g));
        this.itemsToPickUp.add(new ItemStackComparator(new ItemStack((IItemProvider)Items.field_151055_y), false));
    }

    @Override
    public void cleanup() {
        this.entity.field_70715_bh.func_85156_a((Goal)this.pickupItemsGoal);
        this.entity.field_70714_bg.func_85156_a((Goal)this.fellTreesGoal);
        this.entity.field_70714_bg.func_85156_a((Goal)this.depositItemsGoal);
    }

    @Override
    public boolean canPickupItem(ItemStack stack) {
        for (IItemStackComparator comparator : this.itemsToPickUp) {
            if (!comparator.matches(stack)) continue;
            return true;
        }
        return false;
    }
}

