/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.job;

import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.SpiritJobFactory;
import com.github.klikli_dev.occultism.registry.OccultismSpiritJobs;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class SpiritJob
implements INBTSerializable<CompoundNBT> {
    public SpiritEntity entity;
    public ResourceLocation factoryId;

    public SpiritJob(SpiritEntity entity) {
        this.entity = entity;
    }

    public ResourceLocation getFactoryID() {
        return this.factoryId;
    }

    public void setFactoryId(ResourceLocation factoryId) {
        this.factoryId = factoryId;
    }

    public CompoundNBT serializeNBT() {
        return this.writeJobToNBT(new CompoundNBT());
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.readJobFromNBT(nbt);
    }

    public static SpiritJob from(SpiritEntity entity, CompoundNBT nbt) {
        SpiritJobFactory factory = (SpiritJobFactory)OccultismSpiritJobs.REGISTRY.getValue(new ResourceLocation(nbt.func_74779_i("factoryId")));
        SpiritJob job = factory.create(entity);
        job.deserializeNBT(nbt);
        return job;
    }

    public abstract void init();

    public abstract void cleanup();

    public void update() {
    }

    public CompoundNBT writeJobToNBT(CompoundNBT compound) {
        compound.func_74778_a("factoryId", this.getFactoryID().toString());
        return compound;
    }

    public void readJobFromNBT(CompoundNBT compound) {
    }

    public boolean canPickupItem(ItemStack stack) {
        return false;
    }
}

