/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.misc;

import com.github.klikli_dev.occultism.api.common.tile.IStorageController;
import com.github.klikli_dev.occultism.common.data.NonNullArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.items.ItemStackHandler;

public class StorageControllerItemStackHandler
extends ItemStackHandler {
    protected int maxStackSize;
    protected int maxSlots;
    protected IStorageController storageController;

    public StorageControllerItemStackHandler(IStorageController storageController, int size, int maxStackSize) {
        this.stacks = NonNullArrayList.withSize(size, ItemStack.field_190927_a);
        this.storageController = storageController;
        this.maxSlots = size;
        this.maxStackSize = maxStackSize;
    }

    public void setSize(int size) {
        if (size < 0) {
            return;
        }
        this.maxSlots = size;
        if (size > this.stacks.size()) {
            this.stacks.addAll(Collections.nCopies(size - this.stacks.size(), ItemStack.field_190927_a));
        } else if (size < this.stacks.size()) {
            this.prune();
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot > this.maxSlots - 1) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack result = super.extractItem(slot, amount, simulate);
        if (!simulate && this.stacks.size() > this.maxSlots && ((ItemStack)this.stacks.get(slot)).func_190926_b()) {
            this.stacks.remove(slot);
        }
        return result;
    }

    public int getSlotLimit(int slot) {
        return this.maxStackSize;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return this.getSlotLimit(slot);
    }

    public CompoundNBT serializeNBT() {
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            CompoundNBT itemTag = new CompoundNBT();
            ItemStack stack = (ItemStack)this.stacks.get(i);
            itemTag.func_74768_a("Slot", i);
            stack.func_77955_b(itemTag);
            itemTag.func_74768_a("RealSize", stack.func_190916_E());
            nbtTagList.add((Object)itemTag);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Items", (INBT)nbtTagList);
        nbt.func_74768_a("Size", this.stacks.size());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setSize(nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.size());
        ListNBT tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)itemTags);
            stack.func_190920_e(itemTags.func_74762_e("RealSize"));
            this.stacks.set(slot, (Object)stack);
        }
        this.onLoad();
    }

    protected void onContentsChanged(int slot) {
        this.storageController.onContentsChanged();
    }

    public void prune() {
        for (int i = this.stacks.size() - 1; i >= 0 && this.stacks.size() > this.maxSlots; --i) {
            if (!((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            this.stacks.remove(i);
        }
    }
}

