/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.ritual;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.ritual.pentacle.Pentacle;
import com.github.klikli_dev.occultism.common.tile.GoldenSacrificialBowlTileEntity;
import com.github.klikli_dev.occultism.common.tile.SacrificialBowlTileEntity;
import com.github.klikli_dev.occultism.registry.OccultismSounds;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class Ritual
extends ForgeRegistryEntry<Ritual> {
    public static final int SACRIFICIAL_BOWL_RANGE = 8;
    public static final int SACRIFICE_DETECTION_RANGE = 8;
    public static final int ITEM_USE_DETECTION_RANGE = 16;
    public final Pentacle pentacle;
    public final Ingredient startingItem;
    public ResourceLocation additionalIngredientsRecipeId;
    public Predicate<LivingEntity> sacrificePredicate;
    public Predicate<PlayerInteractEvent.RightClickItem> itemUsePredicate;
    public int sacrificialBowlRange;
    public int totalSeconds;
    public float timePerIngredient;
    protected List<Ingredient> additionalIngredients;
    protected boolean additionalIngredientsLoaded;

    public Ritual(Pentacle pentacle, Ingredient startingItem) {
        this(pentacle, startingItem, 10);
    }

    public Ritual(Pentacle pentacle, Ingredient startingItem, int totalSeconds) {
        this(pentacle, startingItem, null, totalSeconds);
    }

    public Ritual(Pentacle pentacle, Ingredient startingItem, String additionalIngredientsRecipeName, int totalSeconds) {
        this(pentacle, startingItem, additionalIngredientsRecipeName, 8, totalSeconds);
    }

    public Ritual(Pentacle pentacle, Ingredient startingItem, String additionalIngredientsRecipeName, int sacrificialBowlRange, int totalSeconds) {
        this.pentacle = pentacle;
        this.startingItem = startingItem;
        if (additionalIngredientsRecipeName != null) {
            this.additionalIngredientsRecipeId = new ResourceLocation("occultism", "ritual_ingredients/" + additionalIngredientsRecipeName);
        }
        this.additionalIngredients = new ArrayList<Ingredient>();
        this.sacrificialBowlRange = sacrificialBowlRange;
        this.totalSeconds = totalSeconds;
        this.timePerIngredient = this.totalSeconds;
    }

    public String getConditionsMessage() {
        return String.format("ritual.%s.conditions", this.getRegistryName().toString().replace(":", "."));
    }

    public String getStartedMessage() {
        return String.format("ritual.%s.started", this.getRegistryName().toString().replace(":", "."));
    }

    public String getInterruptedMessage() {
        return String.format("ritual.%s.interrupted", this.getRegistryName().toString().replace(":", "."));
    }

    public String getFinishedMessage() {
        return String.format("ritual.%s.finished", this.getRegistryName().toString().replace(":", "."));
    }

    public List<Ingredient> getAdditionalIngredients(World world) {
        if (!this.additionalIngredientsLoaded) {
            this.registerAdditionalIngredients(world.func_199532_z());
        }
        return this.additionalIngredients;
    }

    public void registerAdditionalIngredients(RecipeManager recipeManager) {
        this.additionalIngredientsLoaded = true;
        if (this.additionalIngredientsRecipeId != null && recipeManager != null) {
            Optional recipe = recipeManager.func_215367_a(this.additionalIngredientsRecipeId);
            if (recipe.isPresent()) {
                this.additionalIngredients = ((IRecipe)recipe.get()).func_192400_c();
                this.timePerIngredient = (float)this.totalSeconds / (float)(this.additionalIngredients.size() + 1);
            } else {
                Occultism.LOGGER.warn("Additional Ingredients Recipe {} not found for Ritual {}", (Object)this.additionalIngredientsRecipeId, (Object)this.getRegistryName());
            }
        }
    }

    public boolean isValid(World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, ItemStack activationItem, List<Ingredient> remainingAdditionalIngredients) {
        return this.startingItem.test(activationItem) && this.areAdditionalIngredientsFulfilled(world, goldenBowlPosition, remainingAdditionalIngredients) && this.pentacle.getBlockMatcher().validate(world, goldenBowlPosition) != null;
    }

    public void start(World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, ItemStack activationItem) {
        world.func_184133_a(null, goldenBowlPosition, (SoundEvent)OccultismSounds.START_RITUAL.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        castingPlayer.func_146105_b((ITextComponent)new TranslationTextComponent(this.getStartedMessage(), new Object[0]), true);
    }

    public void finish(World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, ItemStack activationItem) {
        world.func_184133_a(null, goldenBowlPosition, (SoundEvent)OccultismSounds.POOF.get(), SoundCategory.BLOCKS, 0.7f, 0.7f);
        castingPlayer.func_146105_b((ITextComponent)new TranslationTextComponent(this.getFinishedMessage(), new Object[0]), true);
    }

    public void interrupt(World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, ItemStack activationItem) {
        world.func_184133_a(null, goldenBowlPosition, SoundEvents.field_187665_Y, SoundCategory.BLOCKS, 0.7f, 0.7f);
        castingPlayer.func_146105_b((ITextComponent)new TranslationTextComponent(this.getInterruptedMessage(), new Object[0]), true);
    }

    public void update(World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, ItemStack activationItem, List<Ingredient> remainingAdditionalIngredients, int time) {
    }

    public void update(World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, ItemStack activationItem, int time) {
        this.update(world, goldenBowlPosition, tileEntity, castingPlayer, activationItem, new ArrayList<Ingredient>(), time);
    }

    public boolean identify(World world, BlockPos goldenBowlPosition, ItemStack activationItem) {
        return this.startingItem.test(activationItem) && this.areAdditionalIngredientsFulfilled(world, goldenBowlPosition, this.getAdditionalIngredients(world)) && this.pentacle.getBlockMatcher().validate(world, goldenBowlPosition) != null;
    }

    public boolean consumeAdditionalIngredients(World world, BlockPos goldenBowlPosition, List<Ingredient> remainingAdditionalIngredients, int time) {
        int ingredientsConsumed;
        if (remainingAdditionalIngredients.isEmpty()) {
            return true;
        }
        int totalIngredientsToConsume = (int)Math.floor((float)time / this.timePerIngredient);
        int ingredientsToConsume = totalIngredientsToConsume - (ingredientsConsumed = this.getAdditionalIngredients(world).size() - remainingAdditionalIngredients.size());
        if (ingredientsToConsume == 0) {
            return true;
        }
        List<SacrificialBowlTileEntity> sacrificialBowls = this.getSacrificialBowls(world, goldenBowlPosition);
        Iterator<Ingredient> it = remainingAdditionalIngredients.iterator();
        for (int consumed = 0; it.hasNext() && consumed < ingredientsToConsume; ++consumed) {
            Ingredient ingredient = it.next();
            if (!this.consumeAdditionalIngredient(world, goldenBowlPosition, sacrificialBowls, ingredient)) {
                return false;
            }
            it.remove();
        }
        return true;
    }

    public boolean consumeAdditionalIngredient(World world, BlockPos goldenBowlPosition, List<SacrificialBowlTileEntity> sacrificialBowls, Ingredient ingredient) {
        for (SacrificialBowlTileEntity sacrificialBowl : sacrificialBowls) {
            if (!((Boolean)sacrificialBowl.itemStackHandler.map(handler -> {
                ItemStack stack = handler.extractItem(0, 1, true);
                if (ingredient.test(stack)) {
                    handler.extractItem(0, 1, false);
                    ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197594_E, (double)sacrificialBowl.func_174877_v().func_177958_n() + 0.5, (double)sacrificialBowl.func_174877_v().func_177956_o() + 1.5, (double)sacrificialBowl.func_174877_v().func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    world.func_184133_a(null, sacrificialBowl.func_174877_v(), (SoundEvent)OccultismSounds.POOF.get(), SoundCategory.BLOCKS, 0.7f, 0.7f);
                    return true;
                }
                return false;
            }).orElse((Object)false)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean areAdditionalIngredientsFulfilled(World world, BlockPos goldenBowlPosition, List<Ingredient> additionalIngredients) {
        return this.matchesAdditionalIngredients(additionalIngredients, this.getItemsOnSacrificialBowls(world, goldenBowlPosition));
    }

    public boolean matchesAdditionalIngredients(List<Ingredient> additionalIngredients, List<ItemStack> items) {
        if (additionalIngredients.size() != items.size()) {
            return false;
        }
        if (additionalIngredients.isEmpty()) {
            return true;
        }
        ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>(items);
        for (Ingredient ingredient : additionalIngredients) {
            boolean isMatched = false;
            for (int i = 0; i < remainingItems.size(); ++i) {
                ItemStack stack = (ItemStack)remainingItems.get(i);
                if (!ingredient.test(stack)) continue;
                isMatched = true;
                remainingItems.remove(i);
                break;
            }
            if (isMatched) continue;
            return false;
        }
        return remainingItems.size() == 0;
    }

    public List<ItemStack> getItemsOnSacrificialBowls(World world, BlockPos goldenBowlPosition) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        List<SacrificialBowlTileEntity> sacrificialBowls = this.getSacrificialBowls(world, goldenBowlPosition);
        for (SacrificialBowlTileEntity sacrificialBowl : sacrificialBowls) {
            sacrificialBowl.itemStackHandler.ifPresent(handler -> {
                ItemStack stack = handler.getStackInSlot(0);
                if (!stack.func_190926_b()) {
                    result.add(stack);
                }
            });
        }
        return result;
    }

    public List<SacrificialBowlTileEntity> getSacrificialBowls(World world, BlockPos goldenBowlPosition) {
        ArrayList<SacrificialBowlTileEntity> result = new ArrayList<SacrificialBowlTileEntity>();
        Iterable blocksToCheck = BlockPos.func_218278_a((BlockPos)goldenBowlPosition.func_177982_a(-this.sacrificialBowlRange, 0, -this.sacrificialBowlRange), (BlockPos)goldenBowlPosition.func_177982_a(this.sacrificialBowlRange, 0, this.sacrificialBowlRange));
        for (BlockPos blockToCheck : blocksToCheck) {
            TileEntity tileEntity = world.func_175625_s(blockToCheck);
            if (!(tileEntity instanceof SacrificialBowlTileEntity) || tileEntity instanceof GoldenSacrificialBowlTileEntity) continue;
            result.add((SacrificialBowlTileEntity)tileEntity);
        }
        return result;
    }

    public void prepareSpiritForSpawn(SpiritEntity spirit, World world, BlockPos goldenBowlPosition, PlayerEntity castingPlayer, String spiritName) {
        spirit.func_213386_a((IWorld)world, world.func_175649_E(goldenBowlPosition), SpawnReason.MOB_SUMMONED, null, null);
        spirit.func_193101_c(castingPlayer);
        spirit.func_70080_a(goldenBowlPosition.func_177958_n(), goldenBowlPosition.func_177956_o(), goldenBowlPosition.func_177952_p(), world.field_73012_v.nextInt(360), 0.0f);
        spirit.func_200203_b((ITextComponent)new StringTextComponent(spiritName));
    }

    public boolean isValidSacrifice(LivingEntity entity) {
        if (this.sacrificePredicate == null) {
            return false;
        }
        return this.sacrificePredicate.test(entity);
    }

    public boolean isValidItemUse(PlayerInteractEvent.RightClickItem event) {
        if (this.itemUsePredicate == null) {
            return false;
        }
        return this.itemUsePredicate.test(event);
    }

    public boolean requiresSacrifice() {
        return this.sacrificePredicate != null;
    }

    public boolean requiresItemUse() {
        return this.itemUsePredicate != null;
    }
}

