/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.ritual;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.SpiritJob;
import com.github.klikli_dev.occultism.common.job.SpiritJobFactory;
import com.github.klikli_dev.occultism.common.ritual.SummonSpiritRitual;
import com.github.klikli_dev.occultism.common.ritual.pentacle.Pentacle;
import com.github.klikli_dev.occultism.common.tile.GoldenSacrificialBowlTileEntity;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.registry.OccultismRituals;
import com.github.klikli_dev.occultism.registry.OccultismSpiritJobs;
import com.github.klikli_dev.occultism.util.ItemNBTUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SummonAfritThunderWeatherRitual
extends SummonSpiritRitual {
    public static final ResourceLocation cowTag = new ResourceLocation("forge", "cows");

    public SummonAfritThunderWeatherRitual() {
        super(null, (Pentacle)OccultismRituals.SUMMON_AFRIT_PENTACLE.get(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), "summon_afrit_thunder_weather", 60);
        this.sacrificePredicate = entity -> EntityTypeTags.func_219762_a().func_199915_b(cowTag).func_199685_a_((Object)entity.func_200600_R());
    }

    @Override
    public void finish(World world, BlockPos goldenBowlPosition, GoldenSacrificialBowlTileEntity tileEntity, PlayerEntity castingPlayer, ItemStack activationItem) {
        super.finish(world, goldenBowlPosition, tileEntity, castingPlayer, activationItem);
        ItemStack copy = activationItem.func_77946_l();
        activationItem.func_190918_g(1);
        ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197594_E, (double)goldenBowlPosition.func_177958_n() + 0.5, (double)goldenBowlPosition.func_177956_o() + 0.5, (double)goldenBowlPosition.func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        SpiritEntity spirit = (SpiritEntity)((EntityType)OccultismEntities.AFRIT.get()).func_200721_a(world);
        this.prepareSpiritForSpawn(spirit, world, goldenBowlPosition, castingPlayer, ItemNBTUtil.getBoundSpiritName(copy));
        SpiritJob job = ((SpiritJobFactory)OccultismSpiritJobs.THUNDER_WEATHER.get()).create(spirit);
        job.init();
        spirit.setJob(job);
        spirit.setSpiritMaxAge(240);
        this.spawnEntity((Entity)spirit, world);
    }

    @Override
    public boolean identify(World world, BlockPos goldenBowlPosition, ItemStack activationItem) {
        return Occultism.CONFIG.rituals.enableThunderWeatherRitual.get() && super.identify(world, goldenBowlPosition, activationItem);
    }
}

