/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.tile;

import com.github.klikli_dev.occultism.common.ritual.Ritual;
import com.github.klikli_dev.occultism.common.tile.SacrificialBowlTileEntity;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.registry.OccultismParticles;
import com.github.klikli_dev.occultism.registry.OccultismRituals;
import com.github.klikli_dev.occultism.registry.OccultismTiles;
import com.github.klikli_dev.occultism.util.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.items.IItemHandler;

public class GoldenSacrificialBowlTileEntity
extends SacrificialBowlTileEntity
implements ITickableTileEntity {
    public Ritual currentRitual;
    public UUID castingPlayerId;
    public PlayerEntity castingPlayer;
    public List<Ingredient> remainingAdditionalIngredients = new ArrayList<Ingredient>();
    public boolean sacrificeProvided;
    public boolean itemUseProvided;
    public int currentTime;

    public GoldenSacrificialBowlTileEntity() {
        super((TileEntityType)OccultismTiles.GOLDEN_SACRIFICIAL_BOWL.get());
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (this.currentRitual != null && compound.func_74764_b("remainingAdditionalIngredientsSize")) {
            byte size = compound.func_74771_c("remainingAdditionalIngredientsSize");
            List<Ingredient> additionalIngredients = this.currentRitual.getAdditionalIngredients(this.field_145850_b);
            this.remainingAdditionalIngredients = size >= 0 && size <= additionalIngredients.size() ? additionalIngredients.subList(additionalIngredients.size() - size, additionalIngredients.size() - 1) : new ArrayList<Ingredient>(additionalIngredients);
        }
        if (compound.func_74764_b("sacrificeProvided")) {
            this.sacrificeProvided = compound.func_74767_n("sacrificeProvided");
        }
        if (compound.func_74764_b("requiredItemUsed")) {
            this.itemUseProvided = compound.func_74767_n("requiredItemUsed");
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.currentRitual != null) {
            if (this.currentRitual.getAdditionalIngredients(this.field_145850_b).size() > 0) {
                compound.func_74774_a("remainingAdditionalIngredientsSize", (byte)this.remainingAdditionalIngredients.size());
            }
            compound.func_74757_a("sacrificeProvided", this.sacrificeProvided);
            compound.func_74757_a("requiredItemUsed", this.itemUseProvided);
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void readNetwork(CompoundNBT compound) {
        super.readNetwork(compound);
        if (compound.func_74764_b("currentRitual")) {
            this.currentRitual = (Ritual)OccultismRituals.RITUAL_REGISTRY.getValue(new ResourceLocation(compound.func_74779_i("currentRitual")));
        }
        if (compound.func_74764_b("castingPlayerId")) {
            this.castingPlayerId = UUID.fromString(compound.func_74779_i("castingPlayerId"));
        }
        this.currentTime = compound.func_74762_e("currentTime");
    }

    @Override
    public CompoundNBT writeNetwork(CompoundNBT compound) {
        if (this.currentRitual != null) {
            compound.func_74778_a("currentRitual", this.currentRitual.getRegistryName().toString());
        }
        if (this.castingPlayerId != null) {
            compound.func_74778_a("castingPlayerId", this.castingPlayerId.toString());
        }
        compound.func_74768_a("currentTime", this.currentTime);
        return super.writeNetwork(compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.currentRitual != null) {
            this.restoreCastingPlayer();
            IItemHandler handler = (IItemHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
            if (!this.currentRitual.isValid(this.field_145850_b, this.field_174879_c, this, this.castingPlayer, handler.getStackInSlot(0), this.remainingAdditionalIngredients)) {
                this.stopRitual(false);
                return;
            }
            if (this.castingPlayer == null || !this.sacrificeFulfilled() || !this.itemUseFulfilled()) {
                if (this.field_145850_b.field_73012_v.nextInt(16) == 0) {
                    ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)OccultismParticles.RITUAL_WAITING.get(), (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian(), 3, 0.0, 0.0, 0.0, 0.0);
                    ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)OccultismParticles.RITUAL_WAITING.get(), (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextGaussian(), (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextGaussian(), 3, 0.0, 0.0, 0.0, 0.0);
                }
                return;
            }
            if (this.field_145850_b.field_73012_v.nextInt(16) == 0) {
                ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197599_J, (double)this.field_174879_c.func_177958_n() + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() / 3.0, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() / 3.0, 5, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                ++this.currentTime;
            }
            this.currentRitual.update(this.field_145850_b, this.field_174879_c, this, this.castingPlayer, handler.getStackInSlot(0), this.currentTime);
            if (!this.currentRitual.consumeAdditionalIngredients(this.field_145850_b, this.field_174879_c, this.remainingAdditionalIngredients, this.currentTime)) {
                this.stopRitual(false);
                return;
            }
            if (this.currentRitual.totalSeconds >= 0 && this.currentTime >= this.currentRitual.totalSeconds) {
                this.stopRitual(true);
            }
        }
    }

    public void restoreCastingPlayer() {
        if (this.castingPlayer == null && this.castingPlayerId != null && this.field_145850_b.func_82737_E() % 600L == 0L) {
            this.castingPlayer = EntityUtil.getPlayerByUuiDGlobal(this.castingPlayerId).orElse(null);
            this.func_70296_d();
            this.markNetworkDirty();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean activate(World world, BlockPos pos, PlayerEntity player, Hand hand, Direction face) {
        if (world.field_72995_K) return true;
        ItemStack activationItem = player.func_184586_b(hand);
        if (activationItem == ItemStack.field_190927_a) {
            return false;
        }
        if (this.currentRitual != null) {
            this.stopRitual(false);
            return true;
        }
        Ritual ritual = OccultismRituals.RITUAL_REGISTRY.getValues().stream().filter(r -> r.identify(world, pos, activationItem)).findFirst().orElse(null);
        if (ritual == null) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(String.format("ritual.%s.does_not_exist", "occultism"), new Object[0]), true);
            return false;
        }
        if (ritual.isValid(world, pos, this, player, activationItem, ritual.getAdditionalIngredients(world))) {
            this.startRitual(player, activationItem, ritual);
            return true;
        }
        player.func_146105_b((ITextComponent)new TranslationTextComponent(ritual.getConditionsMessage(), new Object[0]), true);
        return false;
    }

    public void startRitual(PlayerEntity player, ItemStack activationItem, Ritual ritual) {
        if (!this.field_145850_b.field_72995_K) {
            this.currentRitual = ritual;
            this.castingPlayerId = player.func_110124_au();
            this.castingPlayer = player;
            this.currentTime = 0;
            this.sacrificeProvided = false;
            this.itemUseProvided = false;
            this.remainingAdditionalIngredients = new ArrayList<Ingredient>(ritual.getAdditionalIngredients(this.field_145850_b));
            IItemHandler handler = (IItemHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
            handler.insertItem(0, activationItem.func_77979_a(1), false);
            this.currentRitual.start(this.field_145850_b, this.field_174879_c, this, player, handler.getStackInSlot(0));
            this.func_70296_d();
            this.markNetworkDirty();
        }
    }

    public void stopRitual(boolean finished) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.currentRitual != null && this.castingPlayer != null) {
                IItemHandler handler = (IItemHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
                if (finished) {
                    ItemStack activationItem = handler.getStackInSlot(0);
                    this.currentRitual.finish(this.field_145850_b, this.field_174879_c, this, this.castingPlayer, activationItem);
                } else {
                    this.currentRitual.interrupt(this.field_145850_b, this.field_174879_c, this, this.castingPlayer, handler.getStackInSlot(0));
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)handler.extractItem(0, 1, false));
                }
            }
            this.currentRitual = null;
            this.castingPlayerId = null;
            this.castingPlayer = null;
            this.currentTime = 0;
            this.sacrificeProvided = false;
            this.itemUseProvided = false;
            this.remainingAdditionalIngredients.clear();
            this.func_70296_d();
            this.markNetworkDirty();
        }
    }

    public boolean sacrificeFulfilled() {
        return !this.currentRitual.requiresSacrifice() || this.sacrificeProvided;
    }

    public boolean itemUseFulfilled() {
        return !this.currentRitual.requiresItemUse() || this.itemUseProvided;
    }

    public void notifySacrifice(LivingEntity entityLivingBase) {
        this.sacrificeProvided = true;
    }

    public void notifyItemUse(PlayerInteractEvent.RightClickItem event) {
        this.itemUseProvided = true;
    }
}

