/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.tile;

import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.api.common.tile.IStorageController;
import com.github.klikli_dev.occultism.api.common.tile.IStorageControllerProxy;
import com.github.klikli_dev.occultism.common.block.storage.StableWormholeBlock;
import com.github.klikli_dev.occultism.common.container.storage.StableWormholeContainer;
import com.github.klikli_dev.occultism.common.tile.NetworkedTileEntity;
import com.github.klikli_dev.occultism.registry.OccultismTiles;
import com.github.klikli_dev.occultism.util.TileEntityUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class StableWormholeTileEntity
extends NetworkedTileEntity
implements IStorageControllerProxy,
INamedContainerProvider {
    protected GlobalBlockPos linkedStorageControllerPosition;

    public StableWormholeTileEntity() {
        super((TileEntityType)OccultismTiles.STABLE_WORMHOLE.get());
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Override
    public IStorageController getLinkedStorageController() {
        if (this.linkedStorageControllerPosition != null) {
            TileEntity tileEntity = TileEntityUtil.get(this.field_145850_b, this.linkedStorageControllerPosition);
            if (tileEntity instanceof IStorageController) {
                return (IStorageController)tileEntity;
            }
            this.linkedStorageControllerPosition = null;
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(StableWormholeBlock.LINKED, (Comparable)Boolean.valueOf(false)), 2);
        }
        return null;
    }

    @Override
    public GlobalBlockPos getLinkedStorageControllerPosition() {
        return this.linkedStorageControllerPosition;
    }

    @Override
    public void setLinkedStorageControllerPosition(GlobalBlockPos blockPos) {
        this.linkedStorageControllerPosition = blockPos;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (this.getLinkedStorageController() != null) {
            return ((TileEntity)this.getLinkedStorageController()).getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void readNetwork(CompoundNBT compound) {
        if (compound.func_74764_b("linkedStorageControllerPosition")) {
            this.linkedStorageControllerPosition = GlobalBlockPos.from(compound.func_74775_l("linkedStorageControllerPosition"));
        }
        super.readNetwork(compound);
    }

    @Override
    public CompoundNBT writeNetwork(CompoundNBT compound) {
        if (this.linkedStorageControllerPosition != null) {
            compound.func_218657_a("linkedStorageControllerPosition", (INBT)this.linkedStorageControllerPosition.serializeNBT());
        }
        return super.writeNetwork(compound);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new StableWormholeContainer(id, playerInventory, this);
    }
}

