/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.world;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.block.otherworld.IesniumOreNaturalBlock;
import com.github.klikli_dev.occultism.common.block.otherworld.OtherstoneNaturalBlock;
import com.github.klikli_dev.occultism.common.world.multichunk.MultiChunkFeature;
import com.github.klikli_dev.occultism.common.world.multichunk.MultiChunkFeatureConfig;
import com.github.klikli_dev.occultism.common.world.ore.DimensionOreFeature;
import com.github.klikli_dev.occultism.common.world.ore.DimensionOreFeatureConfig;
import com.github.klikli_dev.occultism.config.OccultismConfig;
import com.github.klikli_dev.occultism.registry.OccultismBiomeFeatures;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.util.BiomeUtil;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldGenHandler {
    protected static final List<BiomeDictionary.Type> UNDERGROUND_GROVE_BIOMES = Occultism.CONFIG.worldGen.undergroundGroveGen.validBiomes.get().stream().map(s -> BiomeDictionary.Type.getType((String)s, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).collect(Collectors.toList());
    protected static final List<DimensionType> UNDERGROUND_GROVE_DIMENSIONS = Occultism.CONFIG.worldGen.undergroundGroveGen.dimensionTypeWhitelist.get().stream().map(s -> DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(s))).collect(Collectors.toList());

    public static void setupOreGeneration() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            WorldGenHandler.addOreFeature(biome, ((OtherstoneNaturalBlock)OccultismBlocks.OTHERSTONE_NATURAL.get()).func_176223_P(), Occultism.CONFIG.worldGen.oreGen.otherstoneNatural);
            WorldGenHandler.addOreFeature(biome, ((Block)OccultismBlocks.COPPER_ORE.get()).func_176223_P(), Occultism.CONFIG.worldGen.oreGen.copperOre);
            WorldGenHandler.addOreFeature(biome, ((Block)OccultismBlocks.SILVER_ORE.get()).func_176223_P(), Occultism.CONFIG.worldGen.oreGen.silverOre);
            WorldGenHandler.addOreFeature(biome, ((IesniumOreNaturalBlock)OccultismBlocks.IESNIUM_ORE_NATURAL.get()).func_176223_P(), Occultism.CONFIG.worldGen.oreGen.iesniumOre);
        }
    }

    public static void addOreFeature(Biome biome, BlockState blockState, OccultismConfig.WorldGenSettings.OreGenSettings.OreSettings settings) {
        List<DimensionType> dimensionWhitelist = settings.dimensionTypeWhitelist.get().stream().map(s -> DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(s))).collect(Collectors.toList());
        if (settings.oreChance.get() > 0) {
            OreFeatureConfig.FillerBlockType fillerBlockType = OreFeatureConfig.FillerBlockType.func_214736_a((String)settings.fillerBlockType.get());
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, ((DimensionOreFeature)OccultismBiomeFeatures.DIMENSION_ORE_FEATURE.get()).func_225566_b_((IFeatureConfig)new DimensionOreFeatureConfig(dimensionWhitelist, fillerBlockType, blockState, settings.oreSize.get())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(settings.oreChance.get(), settings.oreMin.get(), 0, settings.oreMax.get()))));
        }
    }

    public static void setupUndergroundGroveGeneration() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (!BiomeUtil.containsType(biome, UNDERGROUND_GROVE_BIOMES)) continue;
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, ((MultiChunkFeature)OccultismBiomeFeatures.UNDERGROUND_GROVE_FEATURE.get()).func_225566_b_(new MultiChunkFeatureConfig(7, Occultism.CONFIG.worldGen.undergroundGroveGen.groveSpawnChance.get(), Occultism.CONFIG.worldGen.undergroundGroveGen.groveSpawnMin.get(), Occultism.CONFIG.worldGen.undergroundGroveGen.groveSpawnMax.get(), 14653667, UNDERGROUND_GROVE_DIMENSIONS)));
        }
    }
}

