/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.world.cave;

import com.github.klikli_dev.occultism.common.world.cave.CaveDecoratordata;
import com.github.klikli_dev.occultism.common.world.cave.ICaveDecorator;
import com.github.klikli_dev.occultism.util.StaticUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;

public abstract class CaveDecorator
implements ICaveDecorator {
    public static final Tag<Block> CAVE_WALL_BLOCKS = new BlockTags.Wrapper(StaticUtil.modLoc("cave_wall_blocks"));
    public BlockState floorState;
    public BlockState ceilingState;
    public BlockState wallState;

    public CaveDecorator(BlockState floorState, BlockState ceilingState, BlockState wallState) {
        this.floorState = floorState;
        this.ceilingState = ceilingState;
        this.wallState = wallState;
    }

    @Override
    public void finalPass(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, CaveDecoratordata data) {
        data.floorBlocks.forEach(blockPos -> this.finalFloorPass(world, generator, rand, (BlockPos)blockPos));
        data.ceilingBlocks.forEach(blockPos -> this.finalCeilingPass(world, generator, rand, (BlockPos)blockPos));
        data.wallBlocks.keySet().forEach(blockPos -> this.finalWallPass(world, generator, rand, (BlockPos)blockPos));
        data.insideBlocks.forEach(blockPos -> this.finalInsidePass(world, generator, rand, (BlockPos)blockPos));
    }

    @Override
    public void fill(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, CaveDecoratordata data) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_185887_b((IBlockReader)world, pos) == -1.0f || world.func_175710_j(pos)) {
            return;
        }
        if (this.isFloor(world, pos, state)) {
            data.floorBlocks.add(pos);
            this.fillFloor(world, generator, rand, pos, state);
        } else if (this.isCeiling(world, pos, state)) {
            data.ceilingBlocks.add(pos);
            this.fillCeiling(world, generator, rand, pos, state);
        } else if (this.isWall(world, pos, state)) {
            data.wallBlocks.put(pos, this.getBorderDirection(world, pos));
            this.fillWall(world, generator, rand, pos, state);
        } else if (this.isInside(state)) {
            data.insideBlocks.add(pos);
            this.fillInside(world, generator, rand, pos, state);
        }
    }

    public void fillFloor(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, BlockState state) {
        if (this.floorState != null) {
            world.func_180501_a(pos, this.floorState, 2);
        }
    }

    public void fillCeiling(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, BlockState state) {
        if (this.ceilingState != null) {
            world.func_180501_a(pos, this.ceilingState, 2);
        }
    }

    public void fillWall(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, BlockState state) {
        if (this.wallState != null) {
            world.func_180501_a(pos, this.wallState, 2);
        }
    }

    public void fillInside(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, BlockState state) {
    }

    public void finalFloorPass(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos) {
    }

    public void finalCeilingPass(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos) {
    }

    public void finalWallPass(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos) {
    }

    public void finalInsidePass(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos) {
    }

    public boolean isFloor(IWorld world, BlockPos pos, BlockState state) {
        if (!state.func_200015_d((IBlockReader)world, pos)) {
            return false;
        }
        BlockPos upPos = pos.func_177984_a();
        return world.func_175623_d(upPos) || world.func_180495_p(upPos).func_185904_a().func_76222_j();
    }

    public boolean isCeiling(IWorld world, BlockPos pos, BlockState state) {
        if (!state.func_200015_d((IBlockReader)world, pos)) {
            return false;
        }
        BlockPos downPos = pos.func_177977_b();
        return world.func_175623_d(downPos);
    }

    public boolean isWall(IWorld world, BlockPos pos, BlockState state) {
        if (!state.func_200015_d((IBlockReader)world, pos) || !this.isStone(state)) {
            return false;
        }
        return this.isBorder(world, pos);
    }

    public Direction getBorderDirection(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            BlockState stateAt = world.func_180495_p(offsetPos);
            if ((state == stateAt || !world.func_175623_d(offsetPos)) && !stateAt.func_185904_a().func_76222_j()) continue;
            return facing;
        }
        return null;
    }

    public boolean isBorder(IWorld world, BlockPos pos) {
        return this.getBorderDirection(world, pos) != null;
    }

    public boolean isInside(BlockState state) {
        return this.isStone(state);
    }

    public boolean isStone(BlockState state) {
        if (state != null) {
            return state.func_177230_c().func_203417_a(CAVE_WALL_BLOCKS);
        }
        return false;
    }
}

