/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.world.cave;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.block.otherworld.OtherstoneNaturalBlock;
import com.github.klikli_dev.occultism.common.world.cave.CaveDecorator;
import com.github.klikli_dev.occultism.common.world.tree.OtherworldNaturalTree;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.util.NonNullLazy;

public class UndergroundGroveDecorator
extends CaveDecorator {
    protected final NonNullLazy<ConfiguredFeature<TreeFeatureConfig, ?>> treeFeature = NonNullLazy.of(() -> Feature.field_202301_A.func_225566_b_((IFeatureConfig)OtherworldNaturalTree.OTHERWORLD_TREE_NATURAL_CONFIG.get()));

    public UndergroundGroveDecorator() {
        super(Blocks.field_196658_i.func_176223_P(), null, ((OtherstoneNaturalBlock)OccultismBlocks.OTHERSTONE_NATURAL.get()).func_176223_P());
    }

    @Override
    public void finalFloorPass(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_196658_i && rand.nextFloat() < Occultism.CONFIG.worldGen.undergroundGroveGen.grassChance.get()) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150349_c.func_176223_P(), 2);
        }
        if (rand.nextFloat() < Occultism.CONFIG.worldGen.undergroundGroveGen.treeChance.get()) {
            ((TreeFeatureConfig)((ConfiguredFeature)this.treeFeature.get()).field_222738_b).func_227373_a_();
            ((ConfiguredFeature)this.treeFeature.get()).func_222734_a(world, generator, rand, pos.func_177984_a());
        }
    }

    @Override
    public void finalCeilingPass(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos) {
        if (rand.nextFloat() < Occultism.CONFIG.worldGen.undergroundGroveGen.ceilingLightChance.get()) {
            world.func_180501_a(pos, Blocks.field_150426_aN.func_176223_P(), 2);
        }
        super.finalCeilingPass(world, generator, rand, pos);
    }

    @Override
    public void finalWallPass(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos) {
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos offset = pos.func_177972_a(facing);
            BlockPos up = offset.func_177984_a();
            if (!this.isCeiling(world, up, world.func_180495_p(up)) || !(rand.nextFloat() < Occultism.CONFIG.worldGen.undergroundGroveGen.vineChance.get())) continue;
            BlockState stateAt = world.func_180495_p(offset);
            boolean spawnedVine = false;
            while (stateAt.func_177230_c().isAir(stateAt, (IBlockReader)world, offset) && offset.func_177956_o() > 0) {
                world.func_180501_a(offset, (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)VineBlock.func_176267_a((Direction)facing.func_176734_d()), (Comparable)Boolean.valueOf(true)), 2);
                offset = offset.func_177977_b();
                stateAt = world.func_180495_p(offset);
                spawnedVine = true;
            }
            if (!spawnedVine) continue;
            return;
        }
    }
}

