/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.world.multichunk;

import com.github.klikli_dev.occultism.common.world.multichunk.IMultiChunkSubFeature;
import com.github.klikli_dev.occultism.common.world.multichunk.MultiChunkFeatureConfig;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;

public class MultiChunkFeature<T extends MultiChunkFeatureConfig>
extends Feature<T> {
    public final IMultiChunkSubFeature<T> subFeature;

    public MultiChunkFeature(Function<Dynamic<?>, ? extends T> configFactoryIn, IMultiChunkSubFeature<T> subFeature) {
        super(configFactoryIn);
        this.subFeature = subFeature;
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, T config) {
        if (!((MultiChunkFeatureConfig)config).allowedDimensionTypes.contains(worldIn.func_201675_m().func_186058_p()) && !((MultiChunkFeatureConfig)config).allowedDimensionTypes.isEmpty()) {
            return false;
        }
        ChunkPos generatingChunk = new ChunkPos(pos);
        List<BlockPos> rootPositions = this.getRootPositions(generator, (SharedSeedRandom)rand, generatingChunk, config);
        if (rootPositions.isEmpty()) {
            return false;
        }
        boolean generatedAny = false;
        for (BlockPos rootPosition : rootPositions) {
            if (!this.subFeature.place(worldIn, generator, rand, rootPosition, Math3DUtil.bounds(generatingChunk, generator.func_207511_e()), config)) continue;
            generatedAny = true;
        }
        return generatedAny;
    }

    protected List<BlockPos> getRootPositions(ChunkGenerator<?> generator, SharedSeedRandom random, ChunkPos generatingChunk, T config) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(1);
        for (int i = -((MultiChunkFeatureConfig)config).maxChunksToRoot; i < ((MultiChunkFeatureConfig)config).maxChunksToRoot; ++i) {
            for (int j = -((MultiChunkFeatureConfig)config).maxChunksToRoot; j < ((MultiChunkFeatureConfig)config).maxChunksToRoot; ++j) {
                ChunkPos currentChunk = new ChunkPos(generatingChunk.field_77276_a + i, generatingChunk.field_77275_b + j);
                random.func_202427_a(generator.func_202089_c(), currentChunk.field_77276_a, currentChunk.field_77275_b, ((MultiChunkFeatureConfig)config).featureSeedSalt);
                if (random.nextInt(((MultiChunkFeatureConfig)config).chanceToGenerate) != 0) continue;
                result.add(currentChunk.func_180331_a(random.nextInt(15), Math.min(generator.func_207511_e(), ((MultiChunkFeatureConfig)config).minGenerationHeight + random.nextInt(Math.max(0, ((MultiChunkFeatureConfig)config).maxGenerationHeight - ((MultiChunkFeatureConfig)config).minGenerationHeight))), random.nextInt(15)));
            }
        }
        return result;
    }
}

