/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.world.multichunk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.List;
import java.util.Map;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class MultiChunkFeatureConfig
implements IFeatureConfig {
    public final int maxChunksToRoot;
    public final int chanceToGenerate;
    public final int minGenerationHeight;
    public final int maxGenerationHeight;
    public final int featureSeedSalt;
    public final List<DimensionType> allowedDimensionTypes;

    public MultiChunkFeatureConfig(int maxChunksToRoot, int chanceToGenerate, int minGenerationHeight, int maxGenerationHeight, int featureSeedSalt) {
        this(maxChunksToRoot, chanceToGenerate, minGenerationHeight, maxGenerationHeight, featureSeedSalt, (List<DimensionType>)ImmutableList.of((Object)DimensionType.field_223227_a_));
    }

    public MultiChunkFeatureConfig(int maxChunksToRoot, int chanceToGenerate, int minGenerationHeight, int maxGenerationHeight, int featureSeedSalt, List<DimensionType> allowedDimensionTypes) {
        this.maxChunksToRoot = maxChunksToRoot;
        this.chanceToGenerate = chanceToGenerate;
        this.featureSeedSalt = featureSeedSalt;
        this.minGenerationHeight = minGenerationHeight;
        this.maxGenerationHeight = maxGenerationHeight;
        this.allowedDimensionTypes = allowedDimensionTypes;
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.builder().put(ops.createString("maxChunksToRoot"), ops.createInt(this.maxChunksToRoot)).put(ops.createString("chanceToGenerate"), ops.createInt(this.chanceToGenerate)).put(ops.createString("minGenerationHeight"), ops.createInt(this.minGenerationHeight)).put(ops.createString("maxGenerationHeight"), ops.createInt(this.maxGenerationHeight)).put(ops.createString("featureSeedSalt"), ops.createInt(this.featureSeedSalt)).put(ops.createString("chanceToGenerate"), ops.createInt(this.chanceToGenerate)).put(ops.createString("allowedDimensionTypes"), ops.createList(this.allowedDimensionTypes.stream().map(type -> type.func_218175_a(ops)))).build()));
    }

    public static MultiChunkFeatureConfig deserialize(Dynamic<?> in) {
        int maxChunksToRoot = in.get("maxChunksToRoot").asInt(0);
        int chanceToGenerate = in.get("chanceToGenerate").asInt(0);
        int minGenerationHeight = in.get("minGenerationHeight").asInt(0);
        int maxGenerationHeight = in.get("maxGenerationHeight").asInt(0);
        int featureSeedSalt = in.get("featureSeedSalt").asInt(0);
        List allowedDimensionTypes = in.get("allowedDimensionTypes").asList(DimensionType::func_218271_a);
        return new MultiChunkFeatureConfig(maxChunksToRoot, chanceToGenerate, minGenerationHeight, maxGenerationHeight, featureSeedSalt, allowedDimensionTypes);
    }
}

