/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.config;

import com.github.klikli_dev.occultism.config.ConfigBase;
import com.github.klikli_dev.occultism.config.ConfigCategoryBase;
import com.github.klikli_dev.occultism.config.IConfigCache;
import com.github.klikli_dev.occultism.config.value.CachedBoolean;
import com.github.klikli_dev.occultism.config.value.CachedFloat;
import com.github.klikli_dev.occultism.config.value.CachedInt;
import com.github.klikli_dev.occultism.config.value.CachedObject;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class OccultismConfig
extends ConfigBase {
    public final StorageSettings storage;
    public final WorldGenSettings worldGen;
    public final RitualSettings rituals;
    public final DimensionalMineshaftSettings dimensionalMineshaft;
    public final ForgeConfigSpec spec;

    public OccultismConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.storage = new StorageSettings(this, builder);
        this.worldGen = new WorldGenSettings(this, builder);
        this.rituals = new RitualSettings(this, builder);
        this.dimensionalMineshaft = new DimensionalMineshaftSettings(this, builder);
        this.spec = builder.build();
    }

    public class WorldGenSettings
    extends ConfigCategoryBase {
        public final OreGenSettings oreGen;
        public final UndergroundGroveGenSettings undergroundGroveGen;

        public WorldGenSettings(IConfigCache parent, ForgeConfigSpec.Builder builder) {
            super(parent, builder);
            builder.comment("WorldGen Settings").push("worldgen");
            this.oreGen = new OreGenSettings(this, builder);
            this.undergroundGroveGen = new UndergroundGroveGenSettings(this, builder);
            builder.pop();
        }

        public class UndergroundGroveGenSettings
        extends ConfigCategoryBase {
            public CachedObject<List<String>> dimensionTypeWhitelist;
            public CachedObject<List<String>> validBiomes;
            public CachedInt groveSpawnChance;
            public CachedInt groveSpawnMin;
            public CachedInt groveSpawnMax;
            public CachedFloat grassChance;
            public CachedFloat treeChance;
            public CachedFloat vineChance;
            public CachedFloat ceilingLightChance;

            public UndergroundGroveGenSettings(IConfigCache parent, ForgeConfigSpec.Builder builder) {
                super(parent, builder);
                builder.comment("Underground Grove Settings").push("underground_grove");
                this.dimensionTypeWhitelist = CachedObject.cache(this, builder.comment("The dimensions whitelisted for underground grove generation.").define("dimensionWhitelist", Stream.of("overworld").collect(Collectors.toList())));
                List defaultValidBiomes = Arrays.stream(new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.MAGICAL}).map(BiomeDictionary.Type::getName).collect(Collectors.toList());
                this.validBiomes = CachedObject.cache(this, builder.comment("The biome types to spawn underground groves in.").define("validBiomes", defaultValidBiomes));
                this.groveSpawnChance = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The chance for a grove to spawn in a chunk (generates 1/groveSpawnChance chunks on average).").define("groveSpawnChance", (Object)400));
                this.groveSpawnMin = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The min height for a grove to spawn (applied to the center of the grove, not the floor).").define("groveSpawnMin", (Object)25));
                this.groveSpawnMax = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The max height for a grove to spawn (applied to the center of the grove, not the ceiling).").define("groveSpawnMax", (Object)60));
                this.grassChance = CachedFloat.cache(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("The chance grass will spawn in the underground grove.").define("grassChance", (Object)0.6));
                this.treeChance = CachedFloat.cache(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("The chance small trees will spawn in the underground grove.").define("treeChance", (Object)0.1));
                this.vineChance = CachedFloat.cache(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("The chance vines will spawn in the underground grove.").define("vineChance", (Object)0.3));
                this.ceilingLightChance = CachedFloat.cache(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("The chance glowstone will spawn in the ceiling of the underground grove.").define("ceilingLightChance", (Object)0.1));
                builder.pop();
            }
        }

        public class OreGenSettings
        extends ConfigCategoryBase {
            public final OreSettings otherstoneNatural;
            public final OreSettings copperOre;
            public final OreSettings silverOre;
            public final OreSettings iesniumOre;

            public OreGenSettings(IConfigCache parent, ForgeConfigSpec.Builder builder) {
                super(parent, builder);
                builder.comment("Ore Gen Settings").push("oregen");
                List<String> overworld = Stream.of("overworld").collect(Collectors.toList());
                List<String> nether = Stream.of("the_nether").collect(Collectors.toList());
                this.otherstoneNatural = new OreSettings("otherstoneNatural", overworld, OreFeatureConfig.FillerBlockType.NATURAL_STONE, 7, 5, 10, 80, this, builder);
                this.copperOre = new OreSettings("copperOre", overworld, OreFeatureConfig.FillerBlockType.NATURAL_STONE, 9, 20, 20, 64, this, builder);
                this.silverOre = new OreSettings("silverOre", overworld, OreFeatureConfig.FillerBlockType.NATURAL_STONE, 7, 5, 0, 30, this, builder);
                this.iesniumOre = new OreSettings("iesniumOre", nether, OreFeatureConfig.FillerBlockType.NETHERRACK, 3, 10, 10, 128, this, builder);
                builder.pop();
            }

            public class OreSettings
            extends ConfigCategoryBase {
                public final CachedObject<List<String>> dimensionTypeWhitelist;
                public final CachedObject<String> fillerBlockType;
                public final CachedInt oreSize;
                public final CachedInt oreChance;
                public final CachedInt oreMin;
                public final CachedInt oreMax;

                public OreSettings(String oreName, List<String> dimensionTypes, OreFeatureConfig.FillerBlockType fillerBlockType, int size, int chance, int min, int max, IConfigCache parent, ForgeConfigSpec.Builder builder) {
                    super(parent, builder);
                    builder.comment("Ore Settings").push(oreName);
                    this.dimensionTypeWhitelist = CachedObject.cache(this, builder.comment("The dimensions this ore will spawn in.").define("dimensionWhitelist", dimensionTypes));
                    this.fillerBlockType = CachedObject.cache(this, builder.comment("The type of block this ore will spawn in.").define("fillerBlockType", (Object)fillerBlockType.func_214737_a()));
                    this.oreSize = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The size of veins for this ore.").defineInRange("oreSize", size, 0, 127));
                    this.oreChance = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The chance (amount of rolls) for this ore to spawn.").defineInRange("oreChance", chance, 0, 127));
                    this.oreMin = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The minimum height for this ore veins to spawn.").define("oreMin", (Object)min));
                    this.oreMax = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The maximum height for this ore veins to spawn.").define("oreMax", (Object)max));
                    builder.pop();
                }
            }
        }
    }

    public class StorageSettings
    extends ConfigCategoryBase {
        public final CachedInt stabilizerTier1Slots;
        public final CachedInt stabilizerTier2Slots;
        public final CachedInt stabilizerTier3Slots;
        public final CachedInt stabilizerTier4Slots;
        public final CachedInt controllerBaseSlots;

        public StorageSettings(IConfigCache parent, ForgeConfigSpec.Builder builder) {
            super(parent, builder);
            builder.comment("Storage Settings").push("storage");
            this.stabilizerTier1Slots = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The amount of slots the storage stabilizer tier 1 provides.").define("stabilizerTier1Slots", (Object)128));
            this.stabilizerTier2Slots = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The amount of slots the storage stabilizer tier 2 provides.").define("stabilizerTier2Slots", (Object)256));
            this.stabilizerTier3Slots = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The amount of slots the storage stabilizer tier 3 provides.").define("stabilizerTier3Slots", (Object)512));
            this.stabilizerTier4Slots = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The amount of slots the storage stabilizer tier 4 provides.").define("stabilizerTier4Slots", (Object)1024));
            this.controllerBaseSlots = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The amount of slots the storage actuator provides.").define("controllerBaseSlots", (Object)128));
            builder.pop();
        }
    }

    public class RitualSettings
    extends ConfigCategoryBase {
        public final CachedBoolean enableClearWeatherRitual;
        public final CachedBoolean enableRainWeatherRitual;
        public final CachedBoolean enableThunderWeatherRitual;
        public final CachedBoolean enableDayTimeRitual;
        public final CachedBoolean enableNightTimeRitual;

        public RitualSettings(IConfigCache parent, ForgeConfigSpec.Builder builder) {
            super(parent, builder);
            builder.comment("Ritual Settings").push("rituals");
            this.enableClearWeatherRitual = CachedBoolean.cache(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Enables the ritual to clear rainy weather.").define("enableClearWeatherRitual", true));
            this.enableRainWeatherRitual = CachedBoolean.cache(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Enables the ritual to start rainy weather.").define("enableRainWeatherRitual", true));
            this.enableThunderWeatherRitual = CachedBoolean.cache(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Enables the ritual to start a thunderstorm.").define("enableThunderWeatherRitual", true));
            this.enableDayTimeRitual = CachedBoolean.cache(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Enables the ritual to set time to day.").define("enableDayTimeRitual", true));
            this.enableNightTimeRitual = CachedBoolean.cache(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Enables the ritual to set time to night.").define("enableNightTimeRitual", true));
            builder.pop();
        }
    }

    public class DimensionalMineshaftSettings
    extends ConfigCategoryBase {
        public final MinerSpiritSettings minerFoliotUnspecialized;
        public final MinerSpiritSettings minerDjinniOres;

        public DimensionalMineshaftSettings(IConfigCache parent, ForgeConfigSpec.Builder builder) {
            super(parent, builder);
            builder.comment("Dimensional Mineshaft Settings").push("dimensional_mineshaft");
            this.minerFoliotUnspecialized = new MinerSpiritSettings("miner_foliot_unspecialized", parent, builder, 400, 1, 1000);
            this.minerDjinniOres = new MinerSpiritSettings("miner_djinni_ores", parent, builder, 400, 1, 100);
            builder.pop();
        }

        public class MinerSpiritSettings
        extends ConfigCategoryBase {
            public final CachedInt maxMiningTime;
            public final CachedInt rollsPerOperation;
            public final CachedInt durability;

            public MinerSpiritSettings(String oreName, IConfigCache parent, ForgeConfigSpec.Builder builder, int maxMiningTime, int rollsPerOperation, int durability) {
                super(parent, builder);
                builder.comment("Miner Spirit Settings").push(oreName);
                this.maxMiningTime = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The amount of time it takes the spirit to perform one mining operation.").define("maxMiningTime", (Object)maxMiningTime));
                this.rollsPerOperation = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The amount of blocks the spirit will obtain per mining operation").define("rollsPerOperation", (Object)rollsPerOperation));
                this.durability = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The amount of mining operations the spirit can perform before breaking.").define("durability", (Object)durability));
                builder.pop();
            }
        }
    }
}

