/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.config.value;

import com.github.klikli_dev.occultism.config.IConfigCache;
import com.github.klikli_dev.occultism.config.value.ICachedValue;
import net.minecraftforge.common.ForgeConfigSpec;

public class CachedObject<T>
implements ICachedValue {
    protected ForgeConfigSpec.ConfigValue<T> configValue;
    protected T cachedValue;

    protected CachedObject(IConfigCache cache, ForgeConfigSpec.ConfigValue<T> configValue) {
        this.configValue = configValue;
        cache.cache(this);
    }

    @Override
    public void clear() {
        this.cachedValue = null;
    }

    public static <T> CachedObject<T> cache(IConfigCache config, ForgeConfigSpec.ConfigValue<T> configValue) {
        return new CachedObject<T>(config, configValue);
    }

    public T get() {
        if (this.cachedValue == null) {
            this.cachedValue = this.configValue.get();
        }
        return this.cachedValue;
    }

    public void set(T value) {
        this.configValue.set(value);
        this.cachedValue = value;
    }
}

