/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.crafting.recipe;

import com.github.klikli_dev.occultism.api.common.item.IIngredientCopyNBT;
import com.github.klikli_dev.occultism.api.common.item.IIngredientModifyCraftingResult;
import com.github.klikli_dev.occultism.api.common.item.IIngredientPreserve;
import com.github.klikli_dev.occultism.api.common.item.IIngredientPreventCrafting;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CustomShapelessRecipe
extends ShapelessRecipe {
    public static Serializer SERIALIZER = new Serializer();

    public CustomShapelessRecipe(ResourceLocation id, String group, ItemStack result, NonNullList<Ingredient> input) {
        super(id, group, result, input);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_77569_a(@Nonnull CraftingInventory inventory, @Nonnull World world) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IIngredientPreventCrafting) || !((IIngredientPreventCrafting)stack.func_77973_b()).shouldPreventCrafting(stack, (IRecipe)this, inventory, world)) continue;
            return false;
        }
        return super.func_77569_a(inventory, world);
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull CraftingInventory inventory) {
        ItemStack outputWithNBT = this.func_77571_b().func_77946_l();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IIngredientCopyNBT)) continue;
            IIngredientCopyNBT item = (IIngredientCopyNBT)stack.func_77973_b();
            if (stack.func_77978_p() == null || !item.shouldCopyNBT(stack, (IRecipe)this, inventory)) continue;
            CompoundNBT resultNbt = stack.func_77978_p().func_74737_b();
            resultNbt = item.overrideNBT(stack, resultNbt, (IRecipe)this, inventory);
            outputWithNBT.func_77982_d(resultNbt);
        }
        if (outputWithNBT.func_77973_b() instanceof IIngredientModifyCraftingResult) {
            ((IIngredientModifyCraftingResult)outputWithNBT.func_77973_b()).modifyResult((IRecipe)this, inventory, outputWithNBT);
        }
        return outputWithNBT;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inventory) {
        NonNullList remainingItems = super.func_179532_b((IInventory)inventory);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (!(itemStack.func_77973_b() instanceof IIngredientPreserve) || !((IIngredientPreserve)itemStack.func_77973_b()).shouldPreserve(itemStack, (IRecipe<?>)this, inventory)) continue;
            remainingItems.set(i, (Object)itemStack.func_77946_l());
        }
        return remainingItems;
    }

    public IRecipeType<?> func_222127_g() {
        return (IRecipeType)OccultismRecipes.CUSTOM_SHAPELESS_TYPE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CustomShapelessRecipe> {
        private static final ShapelessRecipe.Serializer serializer = new ShapelessRecipe.Serializer();

        public CustomShapelessRecipe read(ResourceLocation recipeId, JsonObject json) {
            ShapelessRecipe recipe = serializer.func_199425_a_(recipeId, json);
            return new CustomShapelessRecipe(recipe.func_199560_c(), recipe.func_193358_e(), recipe.func_77571_b(), (NonNullList<Ingredient>)recipe.func_192400_c());
        }

        public CustomShapelessRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapelessRecipe recipe = serializer.func_199426_a_(recipeId, buffer);
            return new CustomShapelessRecipe(recipe.func_199560_c(), recipe.func_193358_e(), recipe.func_77571_b(), (NonNullList<Ingredient>)recipe.func_192400_c());
        }

        public void write(PacketBuffer buffer, CustomShapelessRecipe recipe) {
            serializer.func_199427_a_(buffer, (ShapelessRecipe)recipe);
        }
    }
}

