/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.datagen;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.block.crops.IReplantableCrops;
import com.github.klikli_dev.occultism.common.block.otherworld.IOtherworldBlock;
import com.github.klikli_dev.occultism.datagen.BaseLootTableProvider;
import com.github.klikli_dev.occultism.datagen.StandardBlockLootTables;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.ILootFunctionConsumer;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.conditions.BlockStateProperty;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.KilledByPlayer;
import net.minecraft.world.storage.loot.conditions.TableBonus;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.fml.RegistryObject;

public class StandardLootTableProvider
extends BaseLootTableProvider {
    InternalBlockLootTable blockLoot = new InternalBlockLootTable();
    InternalEntityLootTable entityLoot = new InternalEntityLootTable();

    public StandardLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    @Override
    protected void addTables() {
        this.blockLoot.addTables();
        this.entityLoot.addTables();
    }

    private class InternalBlockLootTable
    extends StandardBlockLootTables {
        private InternalBlockLootTable() {
        }

        protected void addTables() {
            OccultismBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
                OccultismBlocks.BlockDataGenSettings settings = OccultismBlocks.BLOCK_DATA_GEN_SETTINGS.get(block.getRegistryName());
                if (settings.lootTableType == OccultismBlocks.LootTableType.EMPTY) {
                    this.registerDropNothingLootTable((Block)block);
                } else if (settings.lootTableType == OccultismBlocks.LootTableType.REPLANTABLE_CROP) {
                    IReplantableCrops cropsBlock = (IReplantableCrops)block;
                    BlockStateProperty.Builder lootCondition = BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((IProperty)CropsBlock.field_176488_a, 7));
                    this.func_218507_a((Block)block, InternalBlockLootTable.func_218541_a((Block)block, (Item)cropsBlock.getCropsItem().func_199767_j(), (Item)cropsBlock.getSeedsItem().func_199767_j(), (ILootCondition.IBuilder)lootCondition));
                } else if (settings.lootTableType == OccultismBlocks.LootTableType.DROP_SELF) {
                    this.func_218492_c((Block)block);
                } else if (settings.lootTableType == OccultismBlocks.LootTableType.OTHERWORLD_BLOCK) {
                    this.registerOtherworldBlockTable((Block)block);
                }
            });
            this.func_218522_a((Block)OccultismBlocks.OTHERWORLD_LEAVES.get(), block -> InternalBlockLootTable.func_218540_a((Block)block, (Block)((Block)OccultismBlocks.OTHERWORLD_SAPLING.get()), (float[])field_218579_g));
        }

        protected void func_218507_a(Block blockIn, LootTable.Builder table) {
            StandardLootTableProvider.this.blockLootTable.put(blockIn, table);
        }

        protected void registerOtherworldBlockTable(Block block) {
            if (block instanceof IOtherworldBlock) {
                this.func_218507_a(block, this.createOtherworldBlockTable(block));
            } else {
                Occultism.LOGGER.warn("Tried to register otherworld block loot table for non-otherworld block {}", (Object)block.getRegistryName());
            }
        }

        @Deprecated
        protected void registerOtherworldLeavesTable(Block block, Block coveredSapling, Block uncoveredSapling, float ... chances) {
            if (block instanceof IOtherworldBlock) {
                this.func_218507_a(block, this.otherWorldLeavesDroppingWithChancesAndSticks(block, coveredSapling, uncoveredSapling, chances));
            } else {
                Occultism.LOGGER.warn("Tried to register otherworld leaves loot table for non-otherworld block {}", (Object)block.getRegistryName());
            }
        }

        protected LootTable.Builder createOtherworldBlockTable(Block block) {
            IOtherworldBlock otherworldBlock = (IOtherworldBlock)block;
            BlockStateProperty.Builder uncoveredCondition = BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227195_a_(IOtherworldBlock.UNCOVERED, true));
            LootPool.Builder builder = LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)otherworldBlock.getUncoveredBlock()).func_212840_b_((ILootCondition.IBuilder)uncoveredCondition)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)otherworldBlock.getCoveredBlock())));
            return LootTable.func_216119_b().func_216040_a(builder);
        }

        @Deprecated
        protected LootTable.Builder otherWorldLeavesDroppingWithChancesAndSticks(Block forBlock, Block coveredSapling, Block uncoveredSapling, float ... chances) {
            IOtherworldBlock otherworldBlock = (IOtherworldBlock)forBlock;
            BlockStateProperty.Builder uncoveredCondition = BlockStateProperty.func_215985_a((Block)forBlock).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227195_a_(IOtherworldBlock.UNCOVERED, true));
            return this.droppingAlternativeWithChancesAndSticks(forBlock, (LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)otherworldBlock.getUncoveredBlock()).func_212840_b_((ILootCondition.IBuilder)uncoveredCondition)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)otherworldBlock.getCoveredBlock())), (LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)uncoveredSapling).func_212840_b_((ILootCondition.IBuilder)uncoveredCondition)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)coveredSapling)), chances);
        }

        protected LootTable.Builder droppingAlternativeWithChancesAndSticks(Block leaves, LootEntry.Builder<?> leavesEntry, LootEntry.Builder<?> saplingEntry, float ... chances) {
            return this.droppingAlternativeWithSilkTouchOrShears(leavesEntry, ((LootEntry.Builder)InternalBlockLootTable.func_218560_a((IItemProvider)leaves, saplingEntry)).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])chances))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(field_218577_e).func_216045_a(((StandaloneLootEntry.Builder)InternalBlockLootTable.func_218552_a((IItemProvider)leaves, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151055_y).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
        }

        protected LootTable.Builder droppingAlternativeWithSilkTouchOrShears(LootEntry.Builder<?> mainDropEntry, LootEntry.Builder<?> silkTouchDropEntry) {
            return this.droppingAlternative(mainDropEntry, field_218576_d, silkTouchDropEntry);
        }

        protected LootTable.Builder droppingAlternative(LootEntry.Builder<?> mainDropEntry, ILootCondition.IBuilder condition, LootEntry.Builder<?> alternativeDropEntry) {
            return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)mainDropEntry.func_212840_b_(condition).func_216080_a(alternativeDropEntry)));
        }
    }

    private class InternalEntityLootTable
    extends EntityLootTables {
        private InternalEntityLootTable() {
        }

        protected void addTables() {
            this.func_218582_a((EntityType)OccultismEntities.POSSESSED_ENDERMITE_TYPE.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221828_dx).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
            this.func_218582_a((EntityType)OccultismEntities.POSSESSED_ENDERMAN_TYPE.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151079_bi).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
            this.func_218582_a((EntityType)OccultismEntities.POSSESSED_SKELETON_TYPE.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151032_g).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_196182_dv).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151103_aS).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
            this.func_218582_a((EntityType)OccultismEntities.AFRIT_WILD_TYPE.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)OccultismItems.AFRIT_ESSENCE.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.7f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
            this.func_218582_a((EntityType)OccultismEntities.WILD_HUNT_WITHER_SKELETON_TYPE.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151044_h).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)-1.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151103_aS).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Blocks.field_196705_eO)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f)))));
            this.func_218582_a((EntityType)OccultismEntities.WILD_HUNT_SKELETON_TYPE.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151032_g).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151103_aS).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
        }

        protected void func_218582_a(EntityType<?> type, LootTable.Builder table) {
            StandardLootTableProvider.this.entityLootTable.put(type, table);
        }
    }
}

