/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.handlers;

import com.github.klikli_dev.occultism.common.item.tool.ButcherKnifeItem;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import com.github.klikli_dev.occultism.util.StaticUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="occultism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LootEventHandler {
    private static final ResourceLocation grass = new ResourceLocation("minecraft", "blocks/grass");

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)grass)) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)StaticUtil.modLoc("blocks/grass"))).name("occultism:grass").func_216044_b());
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        LivingEntity trueSource;
        ItemStack knifeItem;
        if (event.isRecentlyHit() && event.getSource().func_76346_g() instanceof LivingEntity && (knifeItem = (trueSource = (LivingEntity)event.getSource().func_76346_g()).func_184586_b(Hand.MAIN_HAND)).func_77973_b() == OccultismItems.BUTCHER_KNIFE.get()) {
            List<ItemStack> loot = ButcherKnifeItem.getLoot(event.getEntityLiving(), knifeItem, trueSource);
            Random rand = event.getEntityLiving().func_70681_au();
            if (!loot.isEmpty()) {
                for (ItemStack stack : loot) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190920_e(rand.nextInt(stack.func_190916_E() + 1) + rand.nextInt(event.getLootingLevel() + 1));
                    Vec3d center = Math3DUtil.center(event.getEntityLiving().func_180425_c());
                    event.getDrops().add(new ItemEntity(event.getEntityLiving().field_70170_p, center.field_72450_a, center.field_72448_b, center.field_72449_c, copy));
                }
            }
        }
    }
}

