/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.integration.jei;

import com.github.klikli_dev.occultism.common.container.storage.StableWormholeContainer;
import com.github.klikli_dev.occultism.common.container.storage.StorageControllerContainer;
import com.github.klikli_dev.occultism.common.container.storage.StorageRemoteContainer;
import com.github.klikli_dev.occultism.integration.jei.JeiSettings;
import com.github.klikli_dev.occultism.integration.jei.StorageControllerRecipeTransferHandler;
import com.github.klikli_dev.occultism.integration.jei.recipes.CrushingRecipeCategory;
import com.github.klikli_dev.occultism.integration.jei.recipes.MinerRecipeCategory;
import com.github.klikli_dev.occultism.integration.jei.recipes.RitualRecipeCategory;
import com.github.klikli_dev.occultism.integration.jei.recipes.SpiritFireRecipeCategory;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.github.klikli_dev.occultism.util.RecipeUtil;
import java.util.Collection;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    protected static IJeiRuntime runtime;

    public static IJeiRuntime getJeiRuntime() {
        return runtime;
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("occultism", "jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new SpiritFireRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrushingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MinerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RitualRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        RecipeManager recipeManager = world.func_199532_z();
        Collection spiritFireRecipes = RecipeUtil.getRecipes(recipeManager, (IRecipeType)OccultismRecipes.SPIRIT_FIRE_TYPE.get()).values();
        registration.addRecipes(spiritFireRecipes, OccultismRecipes.SPIRIT_FIRE.getId());
        Collection crushingRecipes = RecipeUtil.getRecipes(recipeManager, (IRecipeType)OccultismRecipes.CRUSHING_TYPE.get()).values();
        registration.addRecipes(crushingRecipes, OccultismRecipes.CRUSHING.getId());
        Collection minerRecipes = RecipeUtil.getRecipes(recipeManager, (IRecipeType)OccultismRecipes.MINER_TYPE.get()).values();
        registration.addRecipes(minerRecipes, OccultismRecipes.MINER.getId());
        Collection ritualRecipes = RecipeUtil.getRecipes(recipeManager, (IRecipeType)OccultismRecipes.RITUAL_TYPE.get()).values();
        registration.addRecipes(ritualRecipes, OccultismRecipes.RITUAL.getId());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(new StorageControllerRecipeTransferHandler<StorageControllerContainer>(StorageControllerContainer.class), VanillaRecipeCategoryUid.CRAFTING);
        registration.addRecipeTransferHandler(new StorageControllerRecipeTransferHandler<StorageRemoteContainer>(StorageRemoteContainer.class), VanillaRecipeCategoryUid.CRAFTING);
        registration.addRecipeTransferHandler(new StorageControllerRecipeTransferHandler<StableWormholeContainer>(StableWormholeContainer.class), VanillaRecipeCategoryUid.CRAFTING);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)OccultismBlocks.SPIRIT_FIRE.get()), new ResourceLocation[]{OccultismRecipes.SPIRIT_FIRE.getId()});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()), new ResourceLocation[]{OccultismRecipes.MINER.getId()});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get()), new ResourceLocation[]{OccultismRecipes.RITUAL.getId()});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
        JeiSettings.setJeiLoaded(true);
    }
}

