/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.integration.jei.recipes;

import com.github.klikli_dev.occultism.crafting.recipe.CrushingRecipe;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class CrushingRecipeCategory
implements IRecipeCategory<CrushingRecipe> {
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;

    public CrushingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 46);
        this.localizedName = I18n.func_135052_a((String)"occultism.jei.crushing", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("occultism", "textures/gui/jei/arrow.png"), 0, 0, 64, 46);
    }

    public ResourceLocation getUid() {
        return OccultismRecipes.CRUSHING.getId();
    }

    public Class<? extends CrushingRecipe> getRecipeClass() {
        return CrushingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(CrushingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, CrushingRecipe recipe, IIngredients ingredients) {
        int index = 0;
        recipeLayout.getItemStacks().init(index, true, 56, 12);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(++index, false, 94, 12);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(CrushingRecipe recipe, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(76, 14);
        this.drawStringCentered(Minecraft.func_71410_x().field_71466_p, this.getTitle(), 84, 0);
    }

    protected void drawStringCentered(FontRenderer fontRenderer, String text, int x, int y) {
        fontRenderer.func_211126_b(text, (float)x - (float)fontRenderer.func_78256_a(text) / 2.0f, (float)y, 0);
    }
}

