/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.integration.jei.recipes;

import com.github.klikli_dev.occultism.crafting.recipe.MinerRecipe;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class MinerRecipeCategory
implements IRecipeCategory<MinerRecipe> {
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;
    private Map<MinerRecipe, Float> chances = new HashMap<MinerRecipe, Float>();

    public MinerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 46);
        this.localizedName = I18n.func_135052_a((String)"occultism.jei.miner", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("occultism", "textures/gui/jei/arrow.png"), 0, 0, 64, 46);
    }

    public ResourceLocation getUid() {
        return OccultismRecipes.MINER.getId();
    }

    public Class<? extends MinerRecipe> getRecipeClass() {
        return MinerRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(MinerRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ItemStackHandler simulatedHandler = new ItemStackHandler(1);
        simulatedHandler.setStackInSlot(0, ((Ingredient)recipe.func_192400_c().get(0)).func_193365_a()[0]);
        List recipes = world.func_199532_z().func_215370_b((IRecipeType)OccultismRecipes.MINER_TYPE.get(), (IInventory)new RecipeWrapper((IItemHandlerModifiable)simulatedHandler), (World)world);
        List possibleResults = recipes.stream().map(MinerRecipe::getWeightedOutput).collect(Collectors.toList());
        float chance = (float)Math.round((float)recipe.getWeightedOutput().field_76292_a / (float)WeightedRandom.func_76272_a(possibleResults) * 10000.0f) / 100.0f;
        this.chances.put(recipe, Float.valueOf(chance));
    }

    public void setRecipe(IRecipeLayout recipeLayout, MinerRecipe recipe, IIngredients ingredients) {
        int index = 0;
        recipeLayout.getItemStacks().init(index, true, 56, 12);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(++index, false, 94, 12);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(MinerRecipe recipe, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(76, 14);
        String text = I18n.func_135052_a((String)"occultism.jei.miner.chance", (Object[])new Object[]{this.chances.get(recipe)});
        this.drawStringCentered(Minecraft.func_71410_x().field_71466_p, text, 84, 0);
    }

    protected void drawStringCentered(FontRenderer fontRenderer, String text, int x, int y) {
        fontRenderer.func_211126_b(text, (float)x - (float)fontRenderer.func_78256_a(text) / 2.0f, (float)y, 0);
    }
}

