/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.integration.jei.recipes;

import com.github.klikli_dev.occultism.crafting.recipe.SpiritFireRecipe;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class SpiritFireRecipeCategory
implements IRecipeCategory<SpiritFireRecipe> {
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final ItemStack renderStack = new ItemStack((IItemProvider)OccultismItems.SPIRIT_FIRE.get());

    public SpiritFireRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 46);
        this.localizedName = I18n.func_135052_a((String)"occultism.jei.spirit_fire", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("occultism", "textures/gui/jei/spirit_fire.png"), 0, 0, 64, 46);
        this.icon = guiHelper.createDrawableIngredient((Object)this.renderStack);
        this.renderStack.func_196082_o().func_74757_a("RenderFull", true);
    }

    public ResourceLocation getUid() {
        return OccultismRecipes.SPIRIT_FIRE.getId();
    }

    public Class<? extends SpiritFireRecipe> getRecipeClass() {
        return SpiritFireRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(SpiritFireRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, SpiritFireRecipe recipe, IIngredients ingredients) {
        int index = 0;
        recipeLayout.getItemStacks().init(index, true, 40, 12);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(++index, true, 75, 12);
        recipeLayout.getItemStacks().set(index, this.renderStack);
        recipeLayout.getItemStacks().init(++index, false, 110, 12);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(SpiritFireRecipe recipe, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(48, 0);
    }
}

