/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.api.common.tile.IStorageController;
import com.github.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.github.klikli_dev.occultism.network.MessageBase;
import com.github.klikli_dev.occultism.util.StorageUtil;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageRequestOrder
extends MessageBase {
    private GlobalBlockPos storageControllerPosition;
    private GlobalBlockPos targetMachinePosition;
    private ItemStack stack = ItemStack.field_190927_a;

    public MessageRequestOrder(PacketBuffer buf) {
        this.decode(buf);
    }

    public MessageRequestOrder(GlobalBlockPos storageControllerPosition, GlobalBlockPos targetMachinePosition, ItemStack stack) {
        this.storageControllerPosition = storageControllerPosition;
        this.targetMachinePosition = targetMachinePosition;
        this.stack = stack;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayerEntity player, NetworkEvent.Context context) {
        ServerWorld world = minecraftServer.func_71218_a(this.storageControllerPosition.getDimensionType());
        if (!world.func_175667_e(this.storageControllerPosition.getPos())) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(this.storageControllerPosition.getPos());
        if (!(tileEntity instanceof IStorageController)) {
            return;
        }
        IStorageController storageController = (IStorageController)tileEntity;
        StorageUtil.clearOpenOrderSlot(player, true);
        ItemStackComparator comparator = new ItemStackComparator(this.stack, true);
        storageController.addDepositOrder(this.targetMachinePosition, comparator, this.stack.func_190916_E());
        player.func_146105_b((ITextComponent)new TranslationTextComponent("network.messages.occultism.request_order.order_received", new Object[0]), true);
    }

    @Override
    public void encode(PacketBuffer buf) {
        this.storageControllerPosition.encode(buf);
        this.targetMachinePosition.encode(buf);
        buf.func_150788_a(this.stack);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.storageControllerPosition = GlobalBlockPos.from(buf);
        this.targetMachinePosition = GlobalBlockPos.from(buf);
        this.stack = buf.func_150791_c();
    }
}

