/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.github.klikli_dev.occultism.api.common.tile.IStorageController;
import com.github.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.github.klikli_dev.occultism.network.MessageBase;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.util.StorageUtil;
import java.util.HashMap;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class MessageSetRecipe
extends MessageBase {
    private CompoundNBT nbt;
    private int index = 0;

    public MessageSetRecipe(PacketBuffer buf) {
        this.decode(buf);
    }

    public MessageSetRecipe(CompoundNBT nbt) {
        this.nbt = nbt;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayerEntity player, NetworkEvent.Context context) {
        if (!(player.field_71070_bA instanceof IStorageControllerContainer)) {
            return;
        }
        IStorageControllerContainer container = (IStorageControllerContainer)player.field_71070_bA;
        IStorageController storageController = container.getStorageController();
        if (storageController == null) {
            return;
        }
        StorageUtil.clearOpenCraftingMatrix(player, false);
        CraftingInventory craftMatrix = container.getCraftMatrix();
        block0: for (int slot = 0; slot < 9; ++slot) {
            int i;
            HashMap<Integer, ItemStack> map = new HashMap<Integer, ItemStack>();
            ListNBT invList = this.nbt.func_150295_c("s" + slot, 10);
            for (i = 0; i < invList.size(); ++i) {
                ItemStack s = ItemStack.func_199557_a((CompoundNBT)invList.func_150305_b(i));
                map.put(i, s);
            }
            for (i = 0; i < map.size(); ++i) {
                ItemStack stack = (ItemStack)map.get(i);
                if (stack == null || stack.func_190926_b()) continue;
                ItemStackComparator comparator = new ItemStackComparator(stack, true);
                ItemStack extractedStack = StorageUtil.extractItem((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), comparator, 1, true);
                if (extractedStack != null && !extractedStack.func_190926_b() && craftMatrix.func_70301_a(slot).func_190926_b()) {
                    StorageUtil.extractItem((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), comparator, 1, false);
                    craftMatrix.func_70299_a(slot, extractedStack);
                    continue block0;
                }
                if ((stack = storageController.getItemStack(!stack.func_190926_b() ? comparator : null, 1, false)).func_190926_b() || !craftMatrix.func_70301_a(slot).func_190926_b()) continue;
                craftMatrix.func_70299_a(slot, stack);
                continue block0;
            }
        }
        container.updateCraftingSlots(true);
        OccultismPackets.sendTo(player, storageController.getMessageUpdateStacks());
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_150786_a(this.nbt);
        buf.writeInt(this.index);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.nbt = buf.func_150793_b();
        this.index = buf.readInt();
    }
}

