/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.github.klikli_dev.occultism.api.common.data.SortDirection;
import com.github.klikli_dev.occultism.api.common.data.SortType;
import com.github.klikli_dev.occultism.api.common.tile.IStorageAccessor;
import com.github.klikli_dev.occultism.network.MessageBase;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSortItems
extends MessageBase {
    private BlockPos entityPosition;
    private SortDirection sortDirection;
    private SortType sortType;

    public MessageSortItems(PacketBuffer buf) {
        this.decode(buf);
    }

    public MessageSortItems(BlockPos entityPosition, SortDirection sortDirection, SortType sortType) {
        this.entityPosition = entityPosition;
        this.sortDirection = sortDirection;
        this.sortType = sortType;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayerEntity player, NetworkEvent.Context context) {
        if (player.field_71070_bA instanceof IStorageControllerContainer) {
            if (!((IStorageControllerContainer)player.field_71070_bA).isContainerItem()) {
                if (!player.field_70170_p.func_175667_e(this.entityPosition)) {
                    return;
                }
                TileEntity tileEntity = player.field_70170_p.func_175625_s(this.entityPosition);
                if (tileEntity instanceof IStorageAccessor) {
                    IStorageAccessor storageAccessor = (IStorageAccessor)tileEntity;
                    storageAccessor.setSortType(this.sortType);
                    storageAccessor.setSortDirection(this.sortDirection);
                    tileEntity.func_70296_d();
                }
            } else {
                ItemStack stack = player.field_71071_by.func_70448_g();
                stack.func_196082_o().func_74768_a("sortDirection", this.sortDirection.getValue());
                stack.func_77978_p().func_74768_a("sortType", this.sortType.getValue());
            }
        }
    }

    @Override
    public void encode(PacketBuffer byteBuf) {
        byteBuf.func_179255_a(this.entityPosition);
        byteBuf.writeByte(this.sortDirection.getValue());
        byteBuf.writeByte(this.sortType.getValue());
    }

    @Override
    public void decode(PacketBuffer byteBuf) {
        this.entityPosition = byteBuf.func_179259_c();
        this.sortDirection = SortDirection.get(byteBuf.readByte());
        this.sortType = SortType.get(byteBuf.readByte());
    }
}

