/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.registry;

import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.ClearWeatherJob;
import com.github.klikli_dev.occultism.common.job.CrusherJob;
import com.github.klikli_dev.occultism.common.job.DayTimeJob;
import com.github.klikli_dev.occultism.common.job.LumberjackJob;
import com.github.klikli_dev.occultism.common.job.ManageMachineJob;
import com.github.klikli_dev.occultism.common.job.NightTimeJob;
import com.github.klikli_dev.occultism.common.job.RainWeatherJob;
import com.github.klikli_dev.occultism.common.job.SpiritJobFactory;
import com.github.klikli_dev.occultism.common.job.ThunderWeatherJob;
import com.github.klikli_dev.occultism.common.job.TraderJob;
import com.github.klikli_dev.occultism.common.job.TransportItemsJob;
import com.github.klikli_dev.occultism.util.StaticUtil;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class OccultismSpiritJobs {
    public static IForgeRegistry<SpiritJobFactory> REGISTRY = RegistryManager.ACTIVE.getRegistry(SpiritJobFactory.class);
    public static DeferredRegister<SpiritJobFactory> JOBS = new DeferredRegister(REGISTRY, "occultism");
    public static final RegistryObject<SpiritJobFactory> LUMBERJACK = JOBS.register("lumberjack", () -> new SpiritJobFactory(LumberjackJob::new));
    public static final RegistryObject<SpiritJobFactory> MANAGE_MACHINE = JOBS.register("manage_machine", () -> new SpiritJobFactory(ManageMachineJob::new));
    public static final RegistryObject<SpiritJobFactory> TRANSPORT_ITEMS = JOBS.register("transport_items", () -> new SpiritJobFactory(TransportItemsJob::new));
    public static final RegistryObject<SpiritJobFactory> TRADE_OTHERSTONE = JOBS.register("trade_otherstone", () -> new SpiritJobFactory(entity -> new TraderJob((SpiritEntity)entity, StaticUtil.modLoc("spirit_trade/test"))));
    public static final RegistryObject<SpiritJobFactory> TRADE_OTHERWORLD_SAPLINGS = JOBS.register("trade_otherworld_saplings", () -> new SpiritJobFactory(entity -> new TraderJob((SpiritEntity)entity, StaticUtil.modLoc("spirit_trade/test"))));
    public static final RegistryObject<SpiritJobFactory> CRUSH_TIER1 = JOBS.register("crush_tier1", () -> new SpiritJobFactory(entity -> new CrusherJob((SpiritEntity)entity, 2.0f)));
    public static final RegistryObject<SpiritJobFactory> CRUSH_TIER2 = JOBS.register("crush_tier2", () -> new SpiritJobFactory(entity -> new CrusherJob((SpiritEntity)entity, 1.0f)));
    public static final RegistryObject<SpiritJobFactory> CRUSH_TIER3 = JOBS.register("crush_tier3", () -> new SpiritJobFactory(entity -> new CrusherJob((SpiritEntity)entity, 0.5f)));
    public static final RegistryObject<SpiritJobFactory> CRUSH_TIER4 = JOBS.register("crush_tier4", () -> new SpiritJobFactory(entity -> new CrusherJob((SpiritEntity)entity, 0.2f)));
    public static final RegistryObject<SpiritJobFactory> CLEAR_WEATHER = JOBS.register("clear_weather", () -> new SpiritJobFactory(entity -> new ClearWeatherJob((SpiritEntity)entity, 300)));
    public static final RegistryObject<SpiritJobFactory> RAIN_WEATHER = JOBS.register("rain_weather", () -> new SpiritJobFactory(entity -> new RainWeatherJob((SpiritEntity)entity, 600)));
    public static final RegistryObject<SpiritJobFactory> THUNDER_WEATHER = JOBS.register("rain_thunder", () -> new SpiritJobFactory(entity -> new ThunderWeatherJob((SpiritEntity)entity, 1200)));
    public static final RegistryObject<SpiritJobFactory> DAY_TIME = JOBS.register("day_time", () -> new SpiritJobFactory(entity -> new DayTimeJob((SpiritEntity)entity, 600)));
    public static final RegistryObject<SpiritJobFactory> NIGHT_TIME = JOBS.register("night_time", () -> new SpiritJobFactory(entity -> new NightTimeJob((SpiritEntity)entity, 1200)));
}

