/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.util;

import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.github.klikli_dev.occultism.api.common.data.WorkAreaSize;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.ManageMachineJob;
import com.github.klikli_dev.occultism.util.EntityUtil;
import com.github.klikli_dev.occultism.util.TextUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class ItemNBTUtil {
    public static final String SPIRIT_NAME_TAG = "spiritName";
    public static final String SPIRIT_UUID_TAG = "spiritUUID";
    public static final String SPIRIT_DATA_TAG = "spiritData";
    public static final String ITEM_MODE_TAG = "itemMode";
    public static final String WORK_AREA_SIZE_TAG = "workAreaSize";
    public static final String WORK_AREA_POSITION_TAG = "workAreaPosition";
    public static final String DEPOSIT_POSITION_TAG = "depositPosition";
    public static final String DEPOSIT_FACING_TAG = "depositFacing";
    public static final String EXTRACT_POSITION_TAG = "extractPosition";
    public static final String EXTRACT_FACING_TAG = "extractFacing";
    public static final String STORAGE_CONTROLLER_POSITION_TAG = "storageControllerPosition";
    public static final String MANAGED_MACHINE = "managedMachine";

    public static void updateItemNBTFromEntity(ItemStack stack, SpiritEntity entity) {
        ItemNBTUtil.setWorkAreaPosition(stack, entity.getWorkAreaPosition());
        ItemNBTUtil.setDepositPosition(stack, entity.getDepositPosition());
        ItemNBTUtil.setDepostFacing(stack, entity.getDepositFacing());
        ItemNBTUtil.setExtractPosition(stack, entity.getExtractPosition());
        ItemNBTUtil.setExtractFacing(stack, entity.getExtractFacing());
        ItemNBTUtil.setWorkAreaSize(stack, entity.getWorkAreaSize());
        entity.getJob().filter(ManageMachineJob.class::isInstance).map(ManageMachineJob.class::cast).ifPresent(job -> {
            if (job.getStorageControllerPosition() != null) {
                ItemNBTUtil.setStorageControllerPosition(stack, job.getStorageControllerPosition());
            }
            if (job.getManagedMachine() != null) {
                ItemNBTUtil.setManagedMachine(stack, job.getManagedMachine());
            }
        });
    }

    public static void generateBoundSpiritName(ItemStack stack) {
        ItemNBTUtil.setBoundSpiritName(stack, TextUtil.generateName());
    }

    public static void setBoundSpiritName(ItemStack stack, String name) {
        stack.func_196082_o().func_74778_a(SPIRIT_NAME_TAG, name);
    }

    public static String getBoundSpiritName(ItemStack stack) {
        if (!stack.func_196082_o().func_74764_b(SPIRIT_NAME_TAG)) {
            ItemNBTUtil.generateBoundSpiritName(stack);
        }
        return stack.func_77978_p().func_74779_i(SPIRIT_NAME_TAG);
    }

    public static int getItemMode(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (!stack.func_196082_o().func_74764_b(ITEM_MODE_TAG)) {
            ItemNBTUtil.setItemMode(stack, 0);
        }
        return stack.func_77978_p().func_74762_e(ITEM_MODE_TAG);
    }

    public static void setItemMode(ItemStack stack, int mode) {
        stack.func_196082_o().func_74768_a(ITEM_MODE_TAG, mode);
    }

    public static GlobalBlockPos getStorageControllerPosition(ItemStack stack) {
        if (!stack.func_196082_o().func_74764_b(STORAGE_CONTROLLER_POSITION_TAG)) {
            return null;
        }
        return GlobalBlockPos.from(stack.func_77978_p().func_74775_l(STORAGE_CONTROLLER_POSITION_TAG));
    }

    public static void setStorageControllerPosition(ItemStack stack, GlobalBlockPos position) {
        if (position != null) {
            stack.func_77983_a(STORAGE_CONTROLLER_POSITION_TAG, (INBT)position.serializeNBT());
        }
    }

    public static MachineReference getManagedMachine(ItemStack stack) {
        if (!stack.func_196082_o().func_74764_b(MANAGED_MACHINE)) {
            return null;
        }
        return MachineReference.from(stack.func_77978_p().func_74775_l(MANAGED_MACHINE));
    }

    public static void setManagedMachine(ItemStack stack, MachineReference position) {
        if (position != null) {
            stack.func_77983_a(MANAGED_MACHINE, (INBT)position.serializeNBT());
        }
    }

    public static BlockPos getDepositPosition(ItemStack stack) {
        if (!stack.func_196082_o().func_74764_b(DEPOSIT_POSITION_TAG)) {
            return null;
        }
        return BlockPos.func_218283_e((long)stack.func_77978_p().func_74763_f(DEPOSIT_POSITION_TAG));
    }

    public static void setDepositPosition(ItemStack stack, Optional<BlockPos> position) {
        position.ifPresent(p -> stack.func_196082_o().func_74772_a(DEPOSIT_POSITION_TAG, p.func_218275_a()));
    }

    public static Direction getDepositFacing(ItemStack stack) {
        if (!stack.func_196082_o().func_74764_b(DEPOSIT_FACING_TAG)) {
            return null;
        }
        return Direction.values()[stack.func_77978_p().func_74762_e(DEPOSIT_FACING_TAG)];
    }

    public static void setDepostFacing(ItemStack stack, Direction facing) {
        stack.func_196082_o().func_74768_a(DEPOSIT_FACING_TAG, facing.ordinal());
    }

    public static BlockPos getExtractPosition(ItemStack stack) {
        if (!stack.func_196082_o().func_74764_b(EXTRACT_POSITION_TAG)) {
            return null;
        }
        return BlockPos.func_218283_e((long)stack.func_77978_p().func_74763_f(EXTRACT_POSITION_TAG));
    }

    public static void setExtractPosition(ItemStack stack, Optional<BlockPos> position) {
        position.ifPresent(p -> stack.func_196082_o().func_74772_a(EXTRACT_POSITION_TAG, p.func_218275_a()));
    }

    public static Direction getExtractFacing(ItemStack stack) {
        if (!stack.func_196082_o().func_74764_b(EXTRACT_FACING_TAG)) {
            return null;
        }
        return Direction.values()[stack.func_77978_p().func_74762_e(EXTRACT_FACING_TAG)];
    }

    public static void setExtractFacing(ItemStack stack, Direction facing) {
        stack.func_196082_o().func_74768_a(EXTRACT_FACING_TAG, facing.ordinal());
    }

    public static BlockPos getWorkAreaPosition(ItemStack stack) {
        if (!stack.func_196082_o().func_74764_b(WORK_AREA_POSITION_TAG)) {
            return null;
        }
        return BlockPos.func_218283_e((long)stack.func_77978_p().func_74763_f(WORK_AREA_POSITION_TAG));
    }

    public static void setWorkAreaPosition(ItemStack stack, Optional<BlockPos> position) {
        position.ifPresent(p -> stack.func_196082_o().func_74772_a(WORK_AREA_POSITION_TAG, p.func_218275_a()));
    }

    public static WorkAreaSize getWorkAreaSize(ItemStack stack) {
        if (!stack.func_196082_o().func_74764_b(WORK_AREA_SIZE_TAG)) {
            ItemNBTUtil.setWorkAreaSize(stack, WorkAreaSize.SMALL);
        }
        return WorkAreaSize.get(stack.func_77978_p().func_74762_e(WORK_AREA_SIZE_TAG));
    }

    public static void setWorkAreaSize(ItemStack stack, WorkAreaSize workAreaSize) {
        stack.func_196082_o().func_74768_a(WORK_AREA_SIZE_TAG, workAreaSize.getValue());
    }

    public static UUID getSpiritEntityUUID(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (!stack.func_196082_o().func_74764_b(SPIRIT_UUID_TAG)) {
            return null;
        }
        return stack.func_77978_p().func_74775_l(SPIRIT_UUID_TAG).func_186857_a("");
    }

    public static void setSpiritEntityUUID(ItemStack stack, UUID id) {
        CompoundNBT uuidCompound = new CompoundNBT();
        uuidCompound.func_186854_a("", id);
        stack.func_77983_a(SPIRIT_UUID_TAG, (INBT)uuidCompound);
    }

    public static CompoundNBT getSpiritEntityData(ItemStack stack) {
        if (!stack.func_196082_o().func_74764_b(SPIRIT_DATA_TAG)) {
            return null;
        }
        return stack.func_77978_p().func_74775_l(SPIRIT_DATA_TAG);
    }

    public static void setSpiritEntityData(ItemStack stack, CompoundNBT entityData) {
        stack.func_196082_o().func_218657_a(SPIRIT_DATA_TAG, (INBT)entityData);
    }

    public static Optional<SpiritEntity> getSpiritEntity(ItemStack itemStack) {
        return EntityUtil.getEntityByUuiDGlobal(ItemNBTUtil.getSpiritEntityUUID(itemStack)).map(e -> (SpiritEntity)e);
    }
}

