/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.util;

import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class Math3DUtil {
    public static double yaw(Vec3d a, Vec3d b) {
        double dirx = a.field_72450_a - b.field_72450_a;
        double diry = a.field_72448_b - b.field_72448_b;
        double dirz = a.field_72449_c - b.field_72449_c;
        double len = Math.sqrt(dirx * dirx + diry * diry + dirz * dirz);
        double pitch = Math.asin(diry /= len);
        double yaw = Math.atan2(dirz /= len, dirx /= len);
        pitch = pitch * 180.0 / Math.PI;
        yaw = yaw * 180.0 / Math.PI;
        return yaw += 90.0;
    }

    public static Vec3d center(BlockPos pos) {
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static BlockPos clamp(BlockPos pos, AxisAlignedBB bounds) {
        return new BlockPos(MathHelper.func_151237_a((double)pos.func_177958_n(), (double)bounds.field_72340_a, (double)bounds.field_72336_d), MathHelper.func_151237_a((double)pos.func_177956_o(), (double)bounds.field_72338_b, (double)bounds.field_72337_e), MathHelper.func_151237_a((double)pos.func_177952_p(), (double)bounds.field_72339_c, (double)bounds.field_72334_f));
    }

    public static AxisAlignedBB bounds(ChunkPos pos, int maxHeight) {
        return new AxisAlignedBB((double)pos.func_180334_c(), 0.0, (double)pos.func_180333_d(), (double)pos.func_180332_e(), (double)maxHeight, (double)pos.func_180330_f());
    }

    public static List<BlockPos> simpleTrace(BlockPos start, Direction direction, int distance) {
        return BlockPos.func_218281_b((BlockPos)start, (BlockPos)start.func_177967_a(direction, distance)).map(BlockPos::func_185334_h).sorted(Comparator.comparingDouble(arg_0 -> ((BlockPos)start).func_177951_i(arg_0))).collect(Collectors.toList());
    }

    public static BlockPos simpleTrace(BlockPos start, Direction direction, int distance, Predicate<BlockPos> hitCondition) {
        List<BlockPos> positions = Math3DUtil.simpleTrace(start, direction, distance);
        for (BlockPos pos : positions) {
            if (!hitCondition.test(pos)) continue;
            return pos;
        }
        return null;
    }
}

