/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.util;

import com.github.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.github.klikli_dev.occultism.api.common.tile.IStorageController;
import com.github.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class StorageUtil {
    public static void clearOpenCraftingMatrix(ServerPlayerEntity player, boolean sendStackUpdate) {
        if (player.field_71070_bA instanceof IStorageControllerContainer) {
            IStorageControllerContainer container = (IStorageControllerContainer)player.field_71070_bA;
            CraftingInventory craftMatrix = container.getCraftMatrix();
            IStorageController storageController = container.getStorageController();
            if (storageController == null) {
                return;
            }
            for (int i = 0; i < 9; ++i) {
                int remainingAfterInsert;
                int amountBeforeInsert;
                ItemStack stackInSlot = craftMatrix.func_70301_a(i);
                if (stackInSlot.func_190926_b() || (amountBeforeInsert = stackInSlot.func_190916_E()) == (remainingAfterInsert = storageController.insertStack(stackInSlot.func_77946_l(), false))) continue;
                if (remainingAfterInsert == 0) {
                    craftMatrix.func_70299_a(i, ItemStack.field_190927_a);
                    continue;
                }
                craftMatrix.func_70299_a(i, ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)remainingAfterInsert));
            }
            if (sendStackUpdate) {
                OccultismPackets.sendTo(player, storageController.getMessageUpdateStacks());
                ((Container)container).func_75142_b();
            }
        }
    }

    public static void clearOpenOrderSlot(ServerPlayerEntity player, boolean sendStackUpdate) {
        if (player.field_71070_bA instanceof IStorageControllerContainer) {
            int remainingAfterInsert;
            int amountBeforeInsert;
            IStorageControllerContainer container = (IStorageControllerContainer)player.field_71070_bA;
            Inventory orderSlot = container.getOrderSlot();
            IStorageController storageController = container.getStorageController();
            if (storageController == null) {
                return;
            }
            ItemStack stackInSlot = orderSlot.func_70301_a(0);
            if (!stackInSlot.func_190926_b() && (amountBeforeInsert = stackInSlot.func_190916_E()) != (remainingAfterInsert = storageController.insertStack(stackInSlot.func_77946_l(), false))) {
                if (remainingAfterInsert == 0) {
                    orderSlot.func_70299_a(0, ItemStack.field_190927_a);
                } else {
                    orderSlot.func_70299_a(0, ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)remainingAfterInsert));
                }
            }
            if (sendStackUpdate) {
                OccultismPackets.sendTo(player, storageController.getMessageUpdateStacks());
                ((Container)container).func_75142_b();
            }
        }
    }

    public static ItemStack extractItem(IItemHandler itemHandler, ItemStackComparator comparator, int amount, boolean simulate) {
        if (itemHandler == null || comparator == null) {
            return ItemStack.field_190927_a;
        }
        int amountExtracted = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack extractedStack;
            ItemStack slot = itemHandler.getStackInSlot(i);
            if (!comparator.matches(slot) || (extractedStack = itemHandler.extractItem(i, 1, simulate)).func_190926_b()) continue;
            if (++amountExtracted == amount) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)slot, (int)amount);
            }
            --i;
        }
        return ItemStack.field_190927_a;
    }

    public static int getFirstFilledSlot(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public static void dropInventoryItems(TileEntity tileEntity) {
        tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> StorageUtil.dropInventoryItems(tileEntity.func_145831_w(), tileEntity.func_174877_v(), handler));
    }

    public static void dropInventoryItems(World worldIn, BlockPos pos, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemHandler.getStackInSlot(i));
        }
    }
}

